/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.ConfigurationHelper;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;

public final class ChecksumSupport {
    private static final Set<ChecksumAlgorithm> SUPPORTED_CHECKSUM_ALGORITHMS = ImmutableSet.of(ChecksumAlgorithm.CRC32, ChecksumAlgorithm.CRC32_C, ChecksumAlgorithm.SHA1, ChecksumAlgorithm.SHA256);

    private ChecksumSupport() {
    }

    public static ChecksumAlgorithm getChecksumAlgorithm(Configuration conf) {
        return ConfigurationHelper.resolveEnum(conf, "fs.s3a.create.checksum.algorithm", ChecksumAlgorithm.class, configValue -> {
            if (StringUtils.isBlank(configValue)) {
                return null;
            }
            if (ChecksumAlgorithm.CRC32_C.toString().equalsIgnoreCase((String)configValue)) {
                return ChecksumAlgorithm.CRC32_C;
            }
            throw new IllegalArgumentException("Checksum algorithm is not supported: " + configValue);
        });
    }
}

