/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.functional.FutureIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallableSupplier<T>
implements Supplier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CallableSupplier.class);
    private final Callable<T> call;
    private final AuditSpan auditSpan;

    public CallableSupplier(Callable<T> call) {
        this(null, call);
    }

    public CallableSupplier(AuditSpan auditSpan, Callable<T> call) {
        this.call = call;
        this.auditSpan = auditSpan;
    }

    @Override
    public T get() {
        try {
            if (this.auditSpan != null) {
                this.auditSpan.activate();
            }
            return this.call.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    public static <T> CompletableFuture<T> submit(Executor executor, Callable<T> call) {
        return CompletableFuture.supplyAsync(new CallableSupplier<T>(call), executor);
    }

    public static <T> CompletableFuture<T> submit(Executor executor, AuditSpan auditSpan, Callable<T> call) {
        return CompletableFuture.supplyAsync(new CallableSupplier<T>(auditSpan, call), executor);
    }

    public static <T> void waitForCompletion(List<CompletableFuture<T>> futures) throws IOException {
        if (futures.isEmpty()) {
            return;
        }
        CallableSupplier.waitForCompletion(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T waitForCompletion(CompletableFuture<T> future) throws IOException {
        try (DurationInfo ignore = new DurationInfo(LOG, false, "Waiting for task completion", new Object[0]);){
            T t2 = future.join();
            return t2;
        }
        catch (CancellationException e) {
            throw new IOException(e);
        }
        catch (CompletionException e) {
            FutureIO.raiseInnerCause(e);
            return null;
        }
    }

    public static <T> Optional<T> waitForCompletionIgnoringExceptions(@Nullable CompletableFuture<T> future) {
        try {
            return CallableSupplier.maybeAwaitCompletion(future);
        }
        catch (Exception e) {
            LOG.debug("Ignoring exception raised in task completion: ", e);
            return Optional.empty();
        }
    }

    public static <T> Optional<T> maybeAwaitCompletion(@Nullable CompletableFuture<T> future) throws IOException {
        if (future != null) {
            return Optional.ofNullable(CallableSupplier.waitForCompletion(future));
        }
        return Optional.empty();
    }
}

