/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.impl.CSEMaterials;
import org.apache.hadoop.util.Preconditions;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class CSEUtils {
    private CSEUtils() {
    }

    public static boolean isCSEEnabled(String encryptionMethod) {
        return S3AEncryptionMethods.CSE_KMS.getMethod().equals(encryptionMethod) || S3AEncryptionMethods.CSE_CUSTOM.getMethod().equals(encryptionMethod);
    }

    public static boolean isObjectEncrypted(S3AStore store, String key) throws IOException {
        HeadObjectResponse headObjectResponse = store.headObject(key, null, null, null, "getObjectMetadata");
        return headObjectResponse.hasMetadata() && headObjectResponse.metadata().get("x-amz-cek-alg") != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getUnencryptedObjectLength(S3AStore store, String key, long contentLength, HeadObjectResponse headObjectResponse) throws IOException {
        if (!CSEUtils.isObjectEncrypted(store, key)) {
            return contentLength;
        }
        if (headObjectResponse != null) {
            String plaintextLength = headObjectResponse.metadata().get("x-amz-unencrypted-content-length");
            if (headObjectResponse.hasMetadata() && plaintextLength != null && !plaintextLength.isEmpty()) {
                return Long.parseLong(plaintextLength);
            }
        }
        if (contentLength < 16L) return contentLength;
        long minPlaintextLength = contentLength - 16L;
        if (minPlaintextLength < 0L) {
            minPlaintextLength = 0L;
        }
        try (ResponseInputStream<GetObjectResponse> is = store.getRangedS3Object(key, minPlaintextLength, contentLength);){
            int i = 0;
            while (is.read() != -1) {
                ++i;
            }
            long l = minPlaintextLength + (long)i;
            return l;
        }
        catch (Exception e) {
            throw new IOException("Failed to compute unencrypted length", e);
        }
    }

    public static CSEMaterials getClientSideEncryptionMaterials(Configuration conf, String bucket, S3AEncryptionMethods algorithm) throws IOException {
        switch (algorithm) {
            case CSE_KMS: {
                String kmsKeyId = S3AUtils.getS3EncryptionKey(bucket, conf, true);
                Preconditions.checkArgument(kmsKeyId != null && !kmsKeyId.isEmpty(), "KMS keyId cannot be null or empty");
                return new CSEMaterials().withCSEKeyType(CSEMaterials.CSEKeyType.KMS).withConf(conf).withKmsKeyId(kmsKeyId);
            }
            case CSE_CUSTOM: {
                String customCryptoClassName = conf.getTrimmed("fs.s3a.encryption.cse.custom.keyring.class.name");
                Preconditions.checkArgument(customCryptoClassName != null && !customCryptoClassName.isEmpty(), "CSE custom cryptographic class name cannot be null or empty");
                return new CSEMaterials().withCSEKeyType(CSEMaterials.CSEKeyType.CUSTOM).withConf(conf).withCustomCryptographicClassName(customCryptoClassName);
            }
        }
        throw new IllegalArgumentException("Invalid client side encryption algorithm. Only CSE-KMS and CSE-CUSTOM are supported");
    }
}

