/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.BulkDelete;
import org.apache.hadoop.fs.BulkDeleteUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.Tuples;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

public class BulkDeleteOperation
extends AbstractStoreOperation
implements BulkDelete {
    private final BulkDeleteOperationCallbacks callbacks;
    private final Path basePath;
    private final int pageSize;

    public BulkDeleteOperation(StoreContext storeContext, BulkDeleteOperationCallbacks callbacks, Path basePath, int pageSize, AuditSpan span) {
        super(storeContext, span);
        this.callbacks = Objects.requireNonNull(callbacks);
        this.basePath = Objects.requireNonNull(basePath);
        Preconditions.checkArgument(pageSize > 0, "Page size must be greater than 0");
        this.pageSize = pageSize;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public Path basePath() {
        return this.basePath;
    }

    @Override
    public List<Map.Entry<Path, String>> bulkDelete(Collection<Path> paths) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(paths);
        Preconditions.checkArgument(paths.size() <= this.pageSize, "Number of paths (%d) is larger than the page size (%d)", paths.size(), this.pageSize);
        StoreContext context = this.getStoreContext();
        List<ObjectIdentifier> objects = paths.stream().map(p -> {
            Preconditions.checkArgument(p.isAbsolute(), "Path %s is not absolute", p);
            Preconditions.checkArgument(BulkDeleteUtils.validatePathIsUnderParent(p, this.basePath), "Path %s is not under the base path %s", p, this.basePath);
            String k = context.pathToKey((Path)p);
            return (ObjectIdentifier)ObjectIdentifier.builder().key(k).build();
        }).collect(Collectors.toList());
        List<Map.Entry<String, String>> errors = this.callbacks.bulkDelete(objects);
        if (!errors.isEmpty()) {
            List<Map.Entry<Path, String>> outcomeElements = errors.stream().map(error -> Tuples.pair(context.keyToPath((String)error.getKey()), error.getValue())).collect(Collectors.toList());
            return outcomeElements;
        }
        return Collections.emptyList();
    }

    @Override
    public void close() throws IOException {
    }

    public static interface BulkDeleteOperationCallbacks {
        public List<Map.Entry<String, String>> bulkDelete(List<ObjectIdentifier> var1) throws IOException, IllegalArgumentException;
    }
}

