/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AStore;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.impl.CSEMaterials;
import org.apache.hadoop.fs.s3a.impl.S3AFileSystemOperations;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.util.ReflectionUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;

public class BaseS3AFileSystemOperations
implements S3AFileSystemOperations {
    @Override
    public ResponseInputStream<GetObjectResponse> getObject(S3AStore store, GetObjectRequest request, RequestFactory factory) throws IOException {
        return store.getOrCreateS3Client().getObject(request);
    }

    @Override
    public void setCSEGauge(IOStatisticsStore ioStatisticsStore) {
        ioStatisticsStore.setGauge(Statistic.CLIENT_SIDE_ENCRYPTION_ENABLED.getSymbol(), 0L);
    }

    @Override
    public CSEMaterials getClientSideEncryptionMaterials(Configuration conf, String bucket, S3AEncryptionMethods algorithm) {
        return null;
    }

    @Override
    public S3ClientFactory getS3ClientFactory(Configuration conf) {
        Class<S3ClientFactory> s3ClientFactoryClass = conf.getClass("fs.s3a.s3.client.factory.impl", Constants.DEFAULT_S3_CLIENT_FACTORY_IMPL, S3ClientFactory.class);
        return ReflectionUtils.newInstance(s3ClientFactoryClass, conf);
    }

    @Override
    public S3ClientFactory getUnencryptedS3ClientFactory(Configuration conf) {
        return null;
    }

    @Override
    public long getS3ObjectSize(String key, long length, S3AStore store, HeadObjectResponse response) throws IOException {
        return length;
    }
}

