/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.magic;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.commit.MagicCommitPaths;
import org.apache.hadoop.util.Preconditions;

public final class MagicCommitTrackerUtils {
    private MagicCommitTrackerUtils() {
    }

    public static String extractTaskAttemptIdFromPath(Path path) {
        List<String> elementsInPath = MagicCommitPaths.splitPathToElements(path);
        List<String> childrenOfMagicPath = MagicCommitPaths.magicPathChildren(elementsInPath);
        Preconditions.checkArgument(childrenOfMagicPath.size() >= 3, "Magic Path is invalid");
        return childrenOfMagicPath.get(3);
    }

    public static boolean isTrackMagicCommitsInMemoryEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3a.committer.magic.track.commits.in.memory.enabled", false);
    }

    public static boolean isCleanupMagicCommitterEnabled(Configuration conf) {
        return conf.getBoolean("fs.s3a.committer.magic.cleanup.enabled", true);
    }
}

