/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.files;

import java.io.Serializable;
import java.util.StringJoiner;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CompletedPart;

public class UploadEtag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String etag;
    private String checksumAlgorithm;
    private String checksum;

    public UploadEtag() {
    }

    public UploadEtag(String etag, String checksumAlgorithm, String checksum) {
        this.etag = etag;
        this.checksumAlgorithm = checksumAlgorithm;
        this.checksum = checksum;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public void setChecksumAlgorithm(String checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public static UploadEtag fromCompletedPart(CompletedPart completedPart) {
        UploadEtag uploadEtag = new UploadEtag();
        uploadEtag.setEtag(completedPart.eTag());
        if (completedPart.checksumCRC32() != null) {
            uploadEtag.setChecksumAlgorithm(ChecksumAlgorithm.CRC32.toString());
            uploadEtag.setChecksum(completedPart.checksumCRC32());
        }
        if (completedPart.checksumCRC32C() != null) {
            uploadEtag.setChecksumAlgorithm(ChecksumAlgorithm.CRC32_C.toString());
            uploadEtag.setChecksum(completedPart.checksumCRC32C());
        }
        if (completedPart.checksumSHA1() != null) {
            uploadEtag.setChecksumAlgorithm(ChecksumAlgorithm.SHA1.toString());
            uploadEtag.setChecksum(completedPart.checksumSHA1());
        }
        if (completedPart.checksumSHA256() != null) {
            uploadEtag.setChecksumAlgorithm(ChecksumAlgorithm.SHA256.toString());
            uploadEtag.setChecksum(completedPart.checksumSHA256());
        }
        return uploadEtag;
    }

    public static CompletedPart toCompletedPart(UploadEtag uploadEtag, int partNumber) {
        CompletedPart.Builder builder = CompletedPart.builder().partNumber(partNumber).eTag(uploadEtag.etag);
        if (uploadEtag.checksumAlgorithm == null) {
            return (CompletedPart)builder.build();
        }
        ChecksumAlgorithm checksumAlgorithm = ChecksumAlgorithm.fromValue(uploadEtag.checksumAlgorithm);
        switch (checksumAlgorithm) {
            case CRC32: {
                builder.checksumCRC32(uploadEtag.checksum);
                break;
            }
            case CRC32_C: {
                builder.checksumCRC32C(uploadEtag.checksum);
                break;
            }
            case SHA1: {
                builder.checksumSHA1(uploadEtag.checksum);
                break;
            }
            case SHA256: {
                builder.checksumSHA256(uploadEtag.checksum);
                break;
            }
        }
        return (CompletedPart)builder.build();
    }

    public String toString() {
        return new StringJoiner(", ", UploadEtag.class.getSimpleName() + "[", "]").add("serialVersionUID='1'").add("etag='" + this.etag + "'").add("checksumAlgorithm='" + this.checksumAlgorithm + "'").add("checksum='" + this.checksum + "'").toString();
    }
}

