/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialBinding;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialProvider;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractDelegationTokenBinding;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationConstants;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.auth.delegation.FullCredentialsTokenIdentifier;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Preconditions;

public class FullCredentialsTokenBinding
extends AbstractDelegationTokenBinding {
    private static final String NAME = "FullCredentials/001";
    public static final String FULL_TOKEN = "Full Delegation Token";
    private MarshalledCredentials awsCredentials;
    private String credentialOrigin;

    public FullCredentialsTokenBinding() {
        super(NAME, DelegationConstants.FULL_TOKEN_KIND);
    }

    @Override
    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    private void loadAWSCredentials() throws IOException {
        this.credentialOrigin = AbstractS3ATokenIdentifier.createDefaultOriginMessage();
        Configuration conf = this.getConfig();
        URI uri = this.getCanonicalUri();
        S3xLoginHelper.Login secrets = S3AUtils.getAWSAccessKeys(uri, conf);
        if (secrets.hasLogin()) {
            this.awsCredentials = new MarshalledCredentials(secrets.getUser(), secrets.getPassword(), "");
            this.credentialOrigin = this.credentialOrigin + "; source = Hadoop configuration data";
        } else {
            this.awsCredentials = MarshalledCredentialBinding.fromEnvironment(System.getenv());
            this.credentialOrigin = this.awsCredentials.isValid(MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty) ? this.credentialOrigin + "; source = Environment variables" : "no credentials in configuration or environment variables";
        }
        this.awsCredentials.validate(this.credentialOrigin + ": ", MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty);
    }

    @Override
    public AWSCredentialProviderList deployUnbonded() throws IOException {
        this.requireServiceStarted();
        this.loadAWSCredentials();
        return new AWSCredentialProviderList("Full Credentials Token Binding", new MarshalledCredentialProvider(FULL_TOKEN, this.getStoreContext().getFsURI(), this.getConfig(), this.awsCredentials, MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty));
    }

    @Override
    public AbstractS3ATokenIdentifier createTokenIdentifier(Optional<RoleModel.Policy> policy, EncryptionSecrets encryptionSecrets, Text renewer) throws IOException {
        this.requireServiceStarted();
        Preconditions.checkNotNull(this.awsCredentials, "No AWS credentials to use for a delegation token");
        return new FullCredentialsTokenIdentifier(this.getCanonicalUri(), this.getOwnerText(), renewer, this.awsCredentials, encryptionSecrets, this.credentialOrigin);
    }

    @Override
    public AWSCredentialProviderList bindToTokenIdentifier(AbstractS3ATokenIdentifier retrievedIdentifier) throws IOException {
        FullCredentialsTokenIdentifier tokenIdentifier = this.convertTokenIdentifier(retrievedIdentifier, FullCredentialsTokenIdentifier.class);
        return new AWSCredentialProviderList("Full Credentials Token Binding", new MarshalledCredentialProvider(FULL_TOKEN, this.getStoreContext().getFsURI(), this.getConfig(), tokenIdentifier.getMarshalledCredentials(), MarshalledCredentials.CredentialTypeRequired.AnyNonEmpty));
    }

    @Override
    public AbstractS3ATokenIdentifier createEmptyIdentifier() {
        return new FullCredentialsTokenIdentifier();
    }
}

