/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.auth.AwsSignerInitializer;
import org.apache.hadoop.fs.s3a.auth.SignerFactory;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SignerManager.class);
    private final List<AwsSignerInitializer> initializers = new LinkedList<AwsSignerInitializer>();
    private final String bucketName;
    private final DelegationTokenProvider delegationTokenProvider;
    private final Configuration ownerConf;
    private final UserGroupInformation ownerUgi;

    public SignerManager(String bucketName, DelegationTokenProvider delegationTokenProvider, Configuration ownerConf, UserGroupInformation ownerUgi) {
        this.bucketName = bucketName;
        this.delegationTokenProvider = delegationTokenProvider;
        this.ownerConf = ownerConf;
        this.ownerUgi = ownerUgi;
    }

    public void initCustomSigners() {
        String[] customSigners = this.ownerConf.getTrimmedStrings("fs.s3a.custom.signers");
        if (customSigners == null || customSigners.length == 0) {
            LOG.debug("No custom signers specified");
            return;
        }
        for (String customSigner : customSigners) {
            String[] parts = customSigner.split(":");
            if (parts.length != 1 && parts.length != 2 && parts.length != 3) {
                String message = "Invalid format (Expected name, name:SignerClass, name:SignerClass:SignerInitializerClass) for CustomSigner: [" + customSigner + "]";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            if (parts.length == 1) continue;
            SignerManager.maybeRegisterSigner(parts[0], parts[1], this.ownerConf);
            if (parts.length != 3) continue;
            Class<?> clazz = null;
            try {
                clazz = this.ownerConf.getClassByName(parts[2]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("SignerInitializer class [%s] not found for signer [%s]", parts[2], parts[0]), e);
            }
            LOG.debug("Creating signer initializer: [{}] for signer: [{}]", (Object)parts[2], (Object)parts[0]);
            AwsSignerInitializer signerInitializer = (AwsSignerInitializer)ReflectionUtils.newInstance(clazz, null);
            this.initializers.add(signerInitializer);
            signerInitializer.registerStore(this.bucketName, this.ownerConf, this.delegationTokenProvider, this.ownerUgi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void maybeRegisterSigner(String signerName, String signerClassName, Configuration conf) {
        Class<?> clazz;
        if (SignerFactory.isSignerRegistered(signerName)) return;
        try {
            clazz = conf.getClassByName(signerClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(String.format("Signer class [%s] not found for signer [%s]", signerClassName, signerName), cnfe);
        }
        LOG.debug("Registering Custom Signer - [{}->{}]", (Object)signerName, (Object)clazz.getName());
        Class<SignerManager> clazz2 = SignerManager.class;
        synchronized (SignerManager.class) {
            SignerFactory.registerSigner(signerName, clazz);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void close() throws IOException {
        LOG.debug("Unregistering fs from {} initializers", (Object)this.initializers.size());
        for (AwsSignerInitializer initializer : this.initializers) {
            initializer.unregisterStore(this.bucketName, this.ownerConf, this.delegationTokenProvider, this.ownerUgi);
        }
    }
}

