/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.auth.AbstractAWSCredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.profiles.ProfileFile;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ProfileAWSCredentialsProvider
extends AbstractAWSCredentialProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileAWSCredentialsProvider.class);
    public static final String NAME = "org.apache.hadoop.fs.s3a.auth.ProfileAWSCredentialsProvider";
    public static final String PROFILE_FILE = "fs.s3a.auth.profile.file";
    public static final String PROFILE_NAME = "fs.s3a.auth.profile.name";
    public static final String CREDENTIALS_FILE_ENV = "AWS_SHARED_CREDENTIALS_FILE";
    public static final String PROFILE_ENV = "AWS_PROFILE";
    private final ProfileCredentialsProvider pcp;

    private static Path getCredentialsPath(Configuration conf) {
        String credentialsFile = conf.get(PROFILE_FILE, null);
        if (credentialsFile == null) {
            credentialsFile = SystemUtils.getEnvironmentVariable(CREDENTIALS_FILE_ENV, null);
            if (credentialsFile != null) {
                LOG.debug("Fetched credentials file path from environment variable");
            }
        } else {
            LOG.debug("Fetched credentials file path from conf");
        }
        if (credentialsFile == null) {
            LOG.debug("Using default credentials file path");
            return FileSystems.getDefault().getPath(SystemUtils.getUserHome().getPath(), ".aws", "credentials");
        }
        return FileSystems.getDefault().getPath(credentialsFile, new String[0]);
    }

    private static String getCredentialsName(Configuration conf) {
        String profileName = conf.get(PROFILE_NAME, null);
        if (profileName == null) {
            profileName = SystemUtils.getEnvironmentVariable(PROFILE_ENV, null);
            if (profileName == null) {
                profileName = "default";
                LOG.debug("Using default profile name");
            } else {
                LOG.debug("Fetched profile name from environment variable");
            }
        } else {
            LOG.debug("Fetched profile name from conf");
        }
        return profileName;
    }

    public ProfileAWSCredentialsProvider(URI uri, Configuration conf) {
        super(uri, conf);
        ProfileCredentialsProvider.Builder builder = ProfileCredentialsProvider.builder();
        builder.profileName(ProfileAWSCredentialsProvider.getCredentialsName(conf)).profileFile(ProfileFile.builder().content(ProfileAWSCredentialsProvider.getCredentialsPath(conf)).type(ProfileFile.Type.CREDENTIALS).build());
        this.pcp = builder.build();
    }

    public AwsCredentials resolveCredentials() {
        return this.pcp.resolveCredentials();
    }
}

