/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.auth.AbstractSessionCredentialsProvider;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialBinding;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.util.Preconditions;
import software.amazon.awssdk.auth.credentials.AwsCredentials;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MarshalledCredentialProvider
extends AbstractSessionCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.auth.MarshalledCredentialProvider";
    private final MarshalledCredentials credentials;
    private final MarshalledCredentials.CredentialTypeRequired typeRequired;
    private final String component;

    public MarshalledCredentialProvider(String component, URI uri, Configuration conf, MarshalledCredentials credentials, MarshalledCredentials.CredentialTypeRequired typeRequired) throws IOException {
        super(Preconditions.checkNotNull(uri, "No filesystem URI"), conf);
        this.component = component;
        this.typeRequired = typeRequired;
        this.credentials = Preconditions.checkNotNull(credentials);
    }

    @Override
    protected AwsCredentials createCredentials(Configuration config) throws IOException {
        return MarshalledCredentialBinding.toAWSCredentials(this.credentials, this.typeRequired, this.component);
    }
}

