/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.apache.hadoop.fs.s3a.impl.ErrorTranslation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.HttpCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class IAMInstanceCredentialsProvider
implements AwsCredentialsProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(IAMInstanceCredentialsProvider.class);
    private HttpCredentialsProvider iamCredentialsProvider = ((ContainerCredentialsProvider.Builder)ContainerCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
    private boolean isContainerCredentialsProvider = true;

    public AwsCredentials resolveCredentials() {
        try {
            return this.getCredentials();
        }
        catch (SdkClientException e) {
            Throwable t2 = e;
            IOException ioe = ErrorTranslation.maybeExtractIOException("IAM endpoint", e, "resolveCredentials()");
            if (ioe != null) {
                t2 = ioe;
            }
            throw new NoAwsCredentialsException("IAMInstanceCredentialsProvider", e.getMessage(), t2);
        }
    }

    private synchronized AwsCredentials getCredentials() {
        try {
            return this.iamCredentialsProvider.resolveCredentials();
        }
        catch (SdkClientException e) {
            LOG.debug("Failed to get credentials from container provider,", e);
            if (this.isContainerCredentialsProvider) {
                LOG.debug("Switching to instance provider", e);
                this.iamCredentialsProvider.close();
                this.isContainerCredentialsProvider = false;
                this.iamCredentialsProvider = ((InstanceProfileCredentialsProvider.Builder)InstanceProfileCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build();
                return this.iamCredentialsProvider.resolveCredentials();
            }
            throw e;
        }
    }

    public boolean isContainerCredentialsProvider() {
        return this.isContainerCredentialsProvider;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.iamCredentialsProvider != null) {
            this.iamCredentialsProvider.close();
        }
    }

    public String toString() {
        return "IAMInstanceCredentialsProvider{credentialsProvider=" + this.iamCredentialsProvider + ", isContainerCredentialsProvider=" + this.isContainerCredentialsProvider + '}';
    }
}

