/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider;
import org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider;
import org.apache.hadoop.fs.s3a.adapter.AwsV1BindingSupport;
import org.apache.hadoop.fs.s3a.auth.IAMInstanceCredentialsProvider;
import org.apache.hadoop.fs.s3a.impl.InstantiationIOException;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;

public final class CredentialProviderListFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialProviderListFactory.class);
    private static final LogExactlyOnce LOG_REMAPPED_ENTRY = new LogExactlyOnce(LOG);
    @VisibleForTesting
    public static final String E_FORBIDDEN_AWS_PROVIDER = "AWS provider class cannot be used";
    public static final List<Class<?>> STANDARD_AWS_PROVIDERS = Collections.unmodifiableList(Arrays.asList(EnvironmentVariableCredentialsProvider.class, IAMInstanceCredentialsProvider.class, SimpleAWSCredentialsProvider.class, TemporaryAWSCredentialsProvider.class));
    public static final String ANONYMOUS_CREDENTIALS_V1 = "com.amazonaws.auth.AnonymousAWSCredentials";
    public static final String EC2_CONTAINER_CREDENTIALS_V1 = "com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper";
    public static final String EC2_IAM_CREDENTIALS_V1 = "com.amazonaws.auth.InstanceProfileCredentialsProvider";
    public static final String EC2_IAM_CREDENTIALS_V2 = IAMInstanceCredentialsProvider.class.getName();
    public static final String ENVIRONMENT_CREDENTIALS_V1 = "com.amazonaws.auth.EnvironmentVariableCredentialsProvider";
    public static final String ENVIRONMENT_CREDENTIALS_V2 = EnvironmentVariableCredentialsProvider.class.getName();
    public static final String PROFILE_CREDENTIALS_V1 = "com.amazonaws.auth.profile.ProfileCredentialsProvider";
    public static final String PROFILE_CREDENTIALS_V2 = ProfileCredentialsProvider.class.getName();
    private static final Map<String, String> V1_V2_CREDENTIAL_PROVIDER_MAP = CredentialProviderListFactory.initCredentialProvidersMap();

    private CredentialProviderListFactory() {
    }

    public static AWSCredentialProviderList createAWSCredentialProviderList(@Nullable URI binding, Configuration conf) throws IOException {
        S3xLoginHelper.rejectSecretsInURIs(binding);
        AWSCredentialProviderList credentials = CredentialProviderListFactory.buildAWSProviderList(binding, conf, "fs.s3a.aws.credentials.provider", STANDARD_AWS_PROVIDERS, new HashSet());
        LOG.debug("For URI {}, using credentials {}", (Object)binding, (Object)credentials);
        return credentials;
    }

    private static Collection<String> loadAWSProviderClasses(Configuration conf, String key, Class<?> ... defaultValue) throws IOException {
        Collection<String> classnames = conf.getTrimmedStringCollection(key);
        if (classnames.isEmpty()) {
            return Arrays.stream(defaultValue).map(c -> c.getName()).collect(Collectors.toList());
        }
        return classnames;
    }

    private static Map<String, String> initCredentialProvidersMap() {
        HashMap<String, String> v1v2CredentialProviderMap = new HashMap<String, String>();
        v1v2CredentialProviderMap.put(ANONYMOUS_CREDENTIALS_V1, "org.apache.hadoop.fs.s3a.AnonymousAWSCredentialsProvider");
        v1v2CredentialProviderMap.put(EC2_CONTAINER_CREDENTIALS_V1, EC2_IAM_CREDENTIALS_V2);
        v1v2CredentialProviderMap.put(EC2_IAM_CREDENTIALS_V1, EC2_IAM_CREDENTIALS_V2);
        v1v2CredentialProviderMap.put(ENVIRONMENT_CREDENTIALS_V1, ENVIRONMENT_CREDENTIALS_V2);
        v1v2CredentialProviderMap.put(PROFILE_CREDENTIALS_V1, PROFILE_CREDENTIALS_V2);
        return v1v2CredentialProviderMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AWSCredentialProviderList buildAWSProviderList(@Nullable URI binding, Configuration conf, String key, List<Class<?>> defaultValues, Set<Class<?>> forbidden) throws IOException {
        Collection<String> awsClasses = CredentialProviderListFactory.loadAWSProviderClasses(conf, key, defaultValues.toArray(new Class[defaultValues.size()]));
        Map<String, String> awsCredsMappedClasses = S3AUtils.getTrimmedStringCollectionSplitByEquals(conf, "fs.s3a.aws.credentials.provider.mapping");
        Map<String, String> v1v2CredentialProviderMap = V1_V2_CREDENTIAL_PROVIDER_MAP;
        Set forbiddenClassnames = forbidden.stream().map(c -> c.getName()).collect(Collectors.toSet());
        AWSCredentialProviderList providers = new AWSCredentialProviderList();
        for (String className : awsClasses) {
            AwsCredentialsProvider provider;
            String mapped;
            if (v1v2CredentialProviderMap.containsKey(className)) {
                mapped = v1v2CredentialProviderMap.get(className);
                LOG_REMAPPED_ENTRY.warn("Credentials option {} contains AWS v1 SDK entry {}; mapping to {}", key, className, mapped);
                className = mapped;
            } else if (awsCredsMappedClasses != null && awsCredsMappedClasses.containsKey(className)) {
                mapped = awsCredsMappedClasses.get(className);
                LOG_REMAPPED_ENTRY.debug("Credential entry {} is mapped to {}", className, mapped);
                className = mapped;
            }
            if (forbiddenClassnames.contains(className)) {
                throw new InstantiationIOException(InstantiationIOException.Kind.Forbidden, binding, className, key, E_FORBIDDEN_AWS_PROVIDER, null);
            }
            try {
                provider = CredentialProviderListFactory.createAWSV2CredentialProvider(conf, className, binding, key);
            }
            catch (InstantiationIOException e) {
                if (e.getKind() != InstantiationIOException.Kind.IsNotImplementation) throw e;
                if (AwsV1BindingSupport.isAwsV1SdkAvailable()) {
                    LOG.debug("Failed to create {} as v2 credentials, trying to instantiate as v1", (Object)className);
                    try {
                        provider = AwsV1BindingSupport.createAWSV1CredentialProvider(conf, className, binding, key);
                        LOG_REMAPPED_ENTRY.warn("Credentials option {} contains AWS v1 SDK entry {}", key, className);
                    }
                    catch (InstantiationIOException ex) {
                        if (ex.getKind() == InstantiationIOException.Kind.IsNotImplementation) throw e;
                        throw ex;
                    }
                } else {
                    LOG.warn("Failed to instantiate {} as AWS v2 SDK credential provider; AWS V1 SDK is not on the classpth so unable to attempt to instantiate as a v1 provider", (Object)className, (Object)e);
                    throw e;
                }
                LOG.debug("From provider class {} created Aws provider {}", (Object)className, (Object)provider);
            }
            providers.add(provider);
        }
        return providers;
    }

    private static AwsCredentialsProvider createAWSV2CredentialProvider(Configuration conf, String className, @Nullable URI uri, String key) throws IOException {
        LOG.debug("Credential provider class is {}", (Object)className);
        return S3AUtils.getInstanceFromReflection(className, conf, uri, AwsCredentialsProvider.class, "create", key);
    }
}

