/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.auth.AbstractAWSCredentialProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.core.exception.SdkException;

@InterfaceAudience.Private
public abstract class AbstractSessionCredentialsProvider
extends AbstractAWSCredentialProvider {
    private volatile AwsCredentials awsCredentials;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile IOException initializationException;

    public AbstractSessionCredentialsProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
    }

    protected synchronized void init() throws IOException {
        if (this.isInitialized()) {
            return;
        }
        try {
            this.awsCredentials = Invoker.once("create credentials", "", () -> this.createCredentials(this.getConf()));
        }
        catch (IOException e) {
            this.initializationException = e;
            throw e;
        }
        finally {
            this.initialized.set(true);
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    protected abstract AwsCredentials createCredentials(Configuration var1) throws IOException;

    public AwsCredentials resolveCredentials() throws SdkException {
        try {
            if (!this.isInitialized()) {
                this.init();
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof SdkException) {
                throw (SdkException)e.getCause();
            }
            throw new CredentialInitializationException(e.getMessage(), e);
        }
        if (this.awsCredentials == null) {
            throw new CredentialInitializationException("Provider " + this + " has no credentials: " + (this.initializationException != null ? this.initializationException.toString() : ""), this.initializationException);
        }
        return this.awsCredentials;
    }

    public final boolean hasCredentials() {
        return this.awsCredentials != null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @VisibleForTesting
    public IOException getInitializationException() {
        return this.initializationException;
    }

    protected static final class NoCredentials
    implements AwsCredentials {
        protected NoCredentials() {
        }

        public String accessKeyId() {
            return null;
        }

        public String secretAccessKey() {
            return null;
        }
    }
}

