/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit.impl;

import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.audit.AuditIntegration;
import org.apache.hadoop.fs.s3a.audit.AuditorFlags;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.audit.OperationAuditorOptions;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.service.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperationAuditor
extends AbstractService
implements OperationAuditor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOperationAuditor.class);
    public static final String BASE = UUID.randomUUID().toString();
    private static final AtomicLong SPAN_ID_COUNTER = new AtomicLong(1L);
    private IOStatisticsStore iostatistics;
    private OperationAuditorOptions options;
    private AtomicBoolean rejectOutOfSpan = new AtomicBoolean(false);
    private final UUID auditorUUID = UUID.randomUUID();
    private final String auditorID = this.auditorUUID.toString();
    private EnumSet<AuditorFlags> auditorFlags;

    protected AbstractOperationAuditor(String name) {
        super(name);
    }

    @Override
    public void init(OperationAuditorOptions opts) {
        this.options = opts;
        this.iostatistics = Objects.requireNonNull(opts.getIoStatisticsStore());
        this.init(opts.getConfiguration());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.setRejectOutOfSpan(AuditIntegration.isRejectOutOfSpan(conf));
        LOG.debug("{}: Out of span operations will be {}", (Object)this.getName(), (Object)(this.isRejectOutOfSpan() ? "rejected" : "ignored"));
    }

    @Override
    public String getAuditorId() {
        return this.auditorID;
    }

    @Override
    public IOStatisticsStore getIOStatistics() {
        return this.iostatistics;
    }

    protected OperationAuditorOptions getOptions() {
        return this.options;
    }

    protected final String createSpanID() {
        return String.format("%s-%08d", this.auditorID, SPAN_ID_COUNTER.incrementAndGet());
    }

    protected boolean isRejectOutOfSpan() {
        return this.rejectOutOfSpan.get();
    }

    protected void setRejectOutOfSpan(boolean rejectOutOfSpan) {
        this.rejectOutOfSpan.set(rejectOutOfSpan);
    }

    @Override
    public void setAuditFlags(EnumSet<AuditorFlags> flags) {
        this.auditorFlags = flags;
        this.auditorFlagsChanged(flags);
    }

    public EnumSet<AuditorFlags> getAuditorFlags() {
        return this.auditorFlags;
    }

    protected void auditorFlagsChanged(EnumSet<AuditorFlags> flags) {
        if (flags.contains((Object)AuditorFlags.PermitOutOfBandOperations)) {
            LOG.debug("Out of span operations are required by the stream factory");
            this.setRejectOutOfSpan(false);
        }
    }
}

