/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.MultipartUpload;

public final class MultipartUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartUtils.class);

    private MultipartUtils() {
    }

    static RemoteIterator<MultipartUpload> listMultipartUploads(StoreContext storeContext, S3Client s3, @Nullable String prefix, int maxKeys) throws IOException {
        return new UploadIterator(storeContext, s3, maxKeys, prefix);
    }

    public static class UploadIterator
    implements RemoteIterator<MultipartUpload> {
        private ListingIterator lister;
        private ListMultipartUploadsResponse listing;
        private ListIterator<MultipartUpload> batchIterator;

        public UploadIterator(StoreContext storeContext, S3Client s3, int maxKeys, @Nullable String prefix) throws IOException {
            this.lister = new ListingIterator(storeContext, s3, prefix, maxKeys);
            this.requestNextBatch();
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.batchIterator.hasNext() || this.requestNextBatch();
        }

        @Override
        public MultipartUpload next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.batchIterator.next();
        }

        private boolean requestNextBatch() throws IOException {
            if (this.lister.hasNext()) {
                this.listing = this.lister.next();
                this.batchIterator = this.listing.uploads().listIterator();
                return this.batchIterator.hasNext();
            }
            return false;
        }
    }

    static class ListingIterator
    implements RemoteIterator<ListMultipartUploadsResponse> {
        private final String prefix;
        private final RequestFactory requestFactory;
        private final int maxKeys;
        private final S3Client s3;
        private final Invoker invoker;
        private final AuditSpan auditSpan;
        private final StoreContext storeContext;
        private ListMultipartUploadsResponse listing;
        private boolean firstListing = true;
        private int listCount = 0;

        ListingIterator(StoreContext storeContext, S3Client s3, @Nullable String prefix, int maxKeys) throws IOException {
            this.storeContext = storeContext;
            this.s3 = s3;
            this.requestFactory = storeContext.getRequestFactory();
            this.maxKeys = maxKeys;
            this.prefix = prefix;
            this.invoker = storeContext.getInvoker();
            this.auditSpan = storeContext.getActiveAuditSpan();
            this.requestNextBatch();
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.listing == null) {
                return false;
            }
            return this.firstListing || this.listing.isTruncated() != false;
        }

        @Override
        public ListMultipartUploadsResponse next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
            } else {
                if (this.listing == null || !this.listing.isTruncated().booleanValue()) {
                    throw new NoSuchElementException("No more uploads under " + this.prefix);
                }
                this.requestNextBatch();
            }
            return this.listing;
        }

        public String toString() {
            return "Upload iterator: prefix " + this.prefix + "; list count " + this.listCount + "; upload count " + this.listing.uploads().size() + "; isTruncated=" + this.listing.isTruncated();
        }

        private void requestNextBatch() throws IOException {
            try (AuditSpan span = this.auditSpan.activate();){
                ListMultipartUploadsRequest.Builder requestBuilder = this.requestFactory.newListMultipartUploadsRequestBuilder(this.prefix);
                if (!this.firstListing) {
                    requestBuilder.keyMarker(this.listing.nextKeyMarker());
                    requestBuilder.uploadIdMarker(this.listing.nextUploadIdMarker());
                }
                requestBuilder.maxUploads(this.maxKeys);
                ListMultipartUploadsRequest request = (ListMultipartUploadsRequest)((Object)requestBuilder.build());
                LOG.debug("[{}], Requesting next {} uploads prefix {}, next key {}, next upload id {}", this.listCount, this.maxKeys, this.prefix, request.keyMarker(), request.uploadIdMarker());
                ++this.listCount;
                this.listing = this.invoker.retry("listMultipartUploads", this.prefix, true, IOStatisticsBinding.trackDurationOfOperation(this.storeContext.getInstrumentation(), Statistic.OBJECT_MULTIPART_UPLOAD_LIST.getSymbol(), () -> this.s3.listMultipartUploads((ListMultipartUploadsRequest)((Object)((Object)requestBuilder.build())))));
                LOG.debug("Listing found {} upload(s)", (Object)this.listing.uploads().size());
                LOG.debug("New listing state: {}", (Object)this);
            }
        }
    }
}

