/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.FutureIO;
import org.apache.hadoop.util.functional.InvocationRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;

@InterfaceAudience.Private
public class Invoker {
    private static final Logger LOG = LoggerFactory.getLogger(Invoker.class);
    private final RetryPolicy retryPolicy;
    private final Retried retryCallback;
    public static final Retried NO_OP = new Retried(){

        @Override
        public void onFailure(String text, IOException exception, int retries, boolean idempotent) {
        }
    };
    public static final Retried LOG_EVENT = new Retried(){

        @Override
        public void onFailure(String text, IOException exception, int retries, boolean idempotent) {
            LOG.debug("{}: " + exception, (Object)text);
            if (retries == 1) {
                LOG.debug("{}: " + exception, (Object)text, (Object)exception);
            }
        }
    };

    public Invoker(RetryPolicy retryPolicy, Retried retryCallback) {
        this.retryPolicy = retryPolicy;
        this.retryCallback = retryCallback;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public Retried getRetryCallback() {
        return this.retryCallback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T once(String action, String path, CallableRaisingIOE<T> operation) throws IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, false, "%s", action);){
            T t2 = operation.apply();
            return t2;
        }
        catch (SdkException e) {
            throw S3AUtils.translateException(action, path, e);
        }
    }

    public static <T> T onceTrackingDuration(String action, String path, DurationTracker tracker, CallableRaisingIOE<T> operation) throws IOException {
        try {
            return IOStatisticsBinding.invokeTrackingDuration(tracker, operation);
        }
        catch (SdkException e) {
            throw S3AUtils.translateException(action, path, e);
        }
    }

    public static void once(String action, String path, InvocationRaisingIOE operation) throws IOException {
        Invoker.once(action, path, () -> {
            operation.apply();
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T onceInTheFuture(String action, String path, Future<T> future) throws IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, false, "%s", action);){
            T t2 = FutureIO.awaitFuture(future);
            return t2;
        }
        catch (SdkException e) {
            throw S3AUtils.translateException(action, path, e);
        }
    }

    public static <T> void ignoreIOExceptions(Logger log, String action, String path, CallableRaisingIOE<T> operation) {
        try {
            Invoker.once(action, path, operation);
        }
        catch (IOException e) {
            String description = Invoker.toDescription(action, path);
            String error = e.toString();
            log.info("{}: {}", (Object)description, (Object)error);
            log.debug("{}", (Object)description, (Object)e);
        }
    }

    public static void ignoreIOExceptions(Logger log, String action, String path, InvocationRaisingIOE operation) {
        Invoker.ignoreIOExceptions(log, action, path, () -> {
            operation.apply();
            return null;
        });
    }

    public void retry(String action, String path, boolean idempotent, Retried retrying, InvocationRaisingIOE operation) throws IOException {
        this.retry(action, path, idempotent, retrying, () -> {
            operation.apply();
            return null;
        });
    }

    public void maybeRetry(boolean doRetry, String action, String path, boolean idempotent, Retried retrying, InvocationRaisingIOE operation) throws IOException {
        this.maybeRetry(doRetry, action, path, idempotent, retrying, () -> {
            operation.apply();
            return null;
        });
    }

    public void retry(String action, String path, boolean idempotent, InvocationRaisingIOE operation) throws IOException {
        this.retry(action, path, idempotent, this.retryCallback, operation);
    }

    public void maybeRetry(boolean doRetry, String action, String path, boolean idempotent, InvocationRaisingIOE operation) throws IOException {
        this.maybeRetry(doRetry, action, path, idempotent, this.retryCallback, operation);
    }

    public <T> T retry(String action, @Nullable String path, boolean idempotent, CallableRaisingIOE<T> operation) throws IOException {
        return this.retry(action, path, idempotent, this.retryCallback, operation);
    }

    public <T> T retry(String action, @Nullable String path, boolean idempotent, Retried retrying, CallableRaisingIOE<T> operation) throws IOException {
        return (T)this.retryUntranslated(Invoker.toDescription(action, path), idempotent, retrying, () -> Invoker.once(action, path, operation));
    }

    public <T> T maybeRetry(boolean doRetry, String action, @Nullable String path, boolean idempotent, Retried retrying, CallableRaisingIOE<T> operation) throws IOException {
        if (doRetry) {
            return (T)this.retryUntranslated(Invoker.toDescription(action, path), idempotent, retrying, () -> Invoker.once(action, path, operation));
        }
        return Invoker.once(action, path, operation);
    }

    public <T> T retryUntranslated(String text, boolean idempotent, CallableRaisingIOE<T> operation) throws IOException {
        return this.retryUntranslated(text, idempotent, this.retryCallback, operation);
    }

    public <T> T retryUntranslated(String text, boolean idempotent, Retried retrying, CallableRaisingIOE<T> operation) throws IOException {
        Preconditions.checkArgument(retrying != null, "null retrying argument");
        int retryCount = 0;
        while (true) {
            try {
                if (retryCount > 0) {
                    LOG.debug("{} retry #{}", (Object)text, (Object)retryCount);
                }
                return operation.apply();
            }
            catch (IOException | SdkException e) {
                boolean shouldRetry;
                Throwable caught = e;
                LOG.debug("{} ; {}, ", (Object)text, (Object)caught.toString());
                LOG.trace("", caught);
                IOException translated = caught instanceof IOException ? (IOException)caught : S3AUtils.translateException(text, "/", (SdkException)caught);
                try {
                    RetryPolicy.RetryAction retryAction = this.retryPolicy.shouldRetry(translated, retryCount, 0, idempotent);
                    shouldRetry = retryAction.action.equals((Object)RetryPolicy.RetryAction.RETRY.action);
                    if (shouldRetry) {
                        retrying.onFailure(text, translated, retryCount, idempotent);
                        Thread.sleep(retryAction.delayMillis);
                    }
                    ++retryCount;
                    continue;
                }
                catch (InterruptedException e2) {
                    caught = new InterruptedIOException("Interrupted");
                    caught.initCause(e2);
                    shouldRetry = false;
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (Exception e3) {
                    LOG.warn("{}: exception in retry processing", (Object)text, (Object)e3);
                    shouldRetry = false;
                }
                if (shouldRetry) continue;
                if (caught instanceof IOException) {
                    throw (IOException)caught;
                }
                throw (SdkException)caught;
            }
            break;
        }
    }

    public static void quietly(String action, String path, InvocationRaisingIOE operation) {
        try {
            Invoker.once(action, path, operation);
        }
        catch (Exception e) {
            LOG.debug("Action {} failed", (Object)action, (Object)e);
        }
    }

    public static <T> Optional<T> quietlyEval(String action, String path, CallableRaisingIOE<T> operation) {
        try {
            return Optional.of(Invoker.once(action, path, operation));
        }
        catch (Exception e) {
            LOG.debug("Action {} failed", (Object)action, (Object)e);
            return Optional.empty();
        }
    }

    private static String toDescription(String action, @Nullable String path) {
        return action + (StringUtils.isNotEmpty(path) ? " on " + path : "");
    }

    @FunctionalInterface
    public static interface Retried {
        public void onFailure(String var1, IOException var2, int var3, boolean var4);
    }
}

