/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.hadoop.impl.IndexedInputSplit;
import com.hazelcast.jet.hadoop.impl.ReadHdfsMetaSupplierBase;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.file.impl.FileTraverser;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.PermissionsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.ReflectionUtils;

public final class ReadHadoopNewApiP<K, V, R>
extends AbstractProcessor {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private final Configuration configuration;
    private final List<InputSplit> splits;
    private final BiFunctionEx<K, V, R> projectionFn;
    private HadoopFileTraverser<K, V, R> traverser;

    private ReadHadoopNewApiP(@Nonnull Configuration configuration, @Nonnull List<InputSplit> splits, @Nonnull BiFunctionEx<K, V, R> projectionFn) {
        this.configuration = configuration;
        this.splits = splits;
        this.projectionFn = projectionFn;
    }

    protected void init(@Nonnull Processor.Context context) {
        InternalSerializationService serializationService = ((Contexts.ProcCtx)context).serializationService();
        BiFunctionEx & Serializable projectionFn = this.projectionFn;
        if (this.configuration.getBoolean("jet.source.copyonread", true)) {
            BiFunctionEx & Serializable actualProjectionFn = projectionFn;
            projectionFn = (BiFunctionEx & Serializable)(key, value) -> {
                Object result = actualProjectionFn.apply(key, value);
                return result == null ? null : serializationService.toObject((Object)serializationService.toData(result));
            };
        }
        this.traverser = new HadoopFileTraverser(this.configuration, this.splits, projectionFn);
    }

    public boolean isCooperative() {
        return false;
    }

    public boolean complete() {
        return this.emitFromTraverser((Traverser)this.traverser);
    }

    public void close() throws Exception {
        if (this.traverser != null) {
            this.traverser.close();
        }
    }

    private static <K, V> InputFormat<K, V> extractInputFormat(Configuration configuration) throws Exception {
        Class<?> inputFormatClass = configuration.getClass("mapreduce.job.inputformat.class", TextInputFormat.class);
        Constructor<?> constructor = inputFormatClass.getDeclaredConstructor(EMPTY_ARRAY);
        constructor.setAccessible(true);
        InputFormat inputFormat = (InputFormat)constructor.newInstance(new Object[0]);
        ReflectionUtils.setConf(inputFormat, configuration);
        return inputFormat;
    }

    private static <K, V> List<InputSplit> getSplits(Configuration configuration) throws Exception {
        InputFormat<K, V> inputFormat = ReadHadoopNewApiP.extractInputFormat(configuration);
        Job job = Job.getInstance(configuration);
        try {
            return inputFormat.getSplits(job);
        }
        catch (InvalidInputException e) {
            String directory = configuration.get("mapreduce.input.fileinputformat.inputdir", "");
            boolean ignoreFileNotFound = configuration.getBoolean("jet.source.ignorefilenotfound", true);
            if (ignoreFileNotFound) {
                ILogger logger = Logger.getLogger(ReadHadoopNewApiP.class);
                logger.fine("The directory '" + directory + "' does not exist. This source will emit 0 items.");
                return Collections.emptyList();
            }
            throw new JetException("The input " + directory + " matches no files");
        }
    }

    private static boolean shouldSplitOnMembers(Configuration configuration) {
        if (configuration.getBoolean("jet.source.sharedlocalfs", false)) {
            return false;
        }
        Job job = (Job)Util.uncheckCall(() -> Job.getInstance(configuration));
        Path[] inputPaths = FileInputFormat.getInputPaths(job);
        boolean hasLocalFileSystem = false;
        boolean hasRemoteFileSystem = false;
        for (Path inputPath : inputPaths) {
            if (ReadHadoopNewApiP.isLocalFileSystem(inputPath, configuration)) {
                hasLocalFileSystem = true;
                continue;
            }
            hasRemoteFileSystem = true;
        }
        if (hasLocalFileSystem && hasRemoteFileSystem) {
            throw new IllegalArgumentException("LocalFileSystem should be marked as shared when used with other remote file systems");
        }
        return hasLocalFileSystem;
    }

    private static boolean isLocalFileSystem(Path inputPath, Configuration configuration) {
        FileSystem fileSystem = (FileSystem)Util.uncheckCall(() -> inputPath.getFileSystem(configuration));
        return fileSystem instanceof LocalFileSystem || fileSystem instanceof RawLocalFileSystem;
    }

    private static final class HadoopFileTraverser<K, V, R>
    implements FileTraverser<R> {
        private final Configuration configuration;
        private final InputFormat<K, V> inputFormat;
        private final BiFunctionEx<K, V, R> projectionFn;
        private final Traverser<R> delegate;
        private RecordReader<K, V> reader;

        private HadoopFileTraverser(Configuration configuration, List<InputSplit> splits, BiFunctionEx<K, V, R> projectionFn) {
            this.configuration = configuration;
            this.inputFormat = (InputFormat)Util.uncheckCall(() -> ReadHadoopNewApiP.extractInputFormat(configuration));
            this.projectionFn = projectionFn;
            this.delegate = Traversers.traverseIterable(splits).flatMap(this::traverseSplit);
        }

        private Traverser<R> traverseSplit(InputSplit split) {
            try {
                TaskAttemptContextImpl attemptContext = new TaskAttemptContextImpl(this.configuration, new TaskAttemptID());
                this.reader = this.inputFormat.createRecordReader(split, attemptContext);
                this.reader.initialize(split, attemptContext);
            }
            catch (IOException | InterruptedException e) {
                throw ExceptionUtil.sneakyThrow((Throwable)e);
            }
            return () -> {
                try {
                    while (this.reader.nextKeyValue()) {
                        Object projectedRecord = this.projectionFn.apply(this.reader.getCurrentKey(), this.reader.getCurrentValue());
                        if (projectedRecord == null) continue;
                        return projectedRecord;
                    }
                    this.reader.close();
                    return null;
                }
                catch (Exception e) {
                    throw ExceptionUtil.sneakyThrow((Throwable)e);
                }
            };
        }

        public R next() {
            return (R)this.delegate.next();
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private static final class Supplier<K, V, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final Configuration configuration;
        private final BiFunctionEx<K, V, R> projectionFn;
        private final List<IndexedInputSplit> assignedSplits;

        private Supplier(@Nonnull Configuration configuration, @Nonnull List<IndexedInputSplit> assignedSplits, @Nonnull BiFunctionEx<K, V, R> projectionFn) {
            this.configuration = configuration;
            this.projectionFn = projectionFn;
            this.assignedSplits = assignedSplits;
        }

        @Nonnull
        public List<Processor> get(int count) {
            List inputSplits = ReadHadoopNewApiP.shouldSplitOnMembers(this.configuration) ? (List)Util.uncheckCall(() -> ReadHadoopNewApiP.getSplits(this.configuration)) : this.assignedSplits.stream().map(IndexedInputSplit::getNewSplit).collect(Collectors.toList());
            return Util.distributeObjects((int)count, (List)inputSplits).values().stream().map(splits -> new ReadHadoopNewApiP<K, V, R>(this.configuration, (List<InputSplit>)splits, this.projectionFn)).collect(Collectors.toList());
        }
    }

    public static class MetaSupplier<K, V, R>
    extends ReadHdfsMetaSupplierBase<R> {
        static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private Configuration configuration;
        private final ConsumerEx<Configuration> configureFn;
        private final BiFunctionEx<K, V, R> projectionFn;
        private final Permission permission;
        private transient Map<Address, List<IndexedInputSplit>> assigned;

        public MetaSupplier(@Nullable Permission permission, @Nonnull Configuration configuration, @Nonnull ConsumerEx<Configuration> configureFn, @Nonnull BiFunctionEx<K, V, R> projectionFn) {
            this.permission = permission;
            this.configuration = configuration;
            this.configureFn = configureFn;
            this.projectionFn = projectionFn;
        }

        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
            super.init(context);
            PermissionsUtil.checkPermission(this.configureFn, (ProcessorMetaSupplier.Context)context);
            this.updateConfiguration();
            if (ReadHadoopNewApiP.shouldSplitOnMembers(this.configuration)) {
                this.assigned = new HashMap<Address, List<IndexedInputSplit>>();
            } else {
                List<InputSplit> splits = ReadHadoopNewApiP.getSplits(this.configuration);
                IndexedInputSplit[] indexedInputSplits = new IndexedInputSplit[splits.size()];
                Arrays.setAll(indexedInputSplits, i -> new IndexedInputSplit(i, (InputSplit)splits.get(i)));
                Address[] addresses = (Address[])context.hazelcastInstance().getCluster().getMembers().stream().map(Member::getAddress).toArray(Address[]::new);
                this.assigned = this.assignSplitsToMembers(indexedInputSplits, addresses);
                this.printAssignments(this.assigned);
            }
        }

        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return address -> new Supplier<K, V, R>(this.configuration, this.assigned.getOrDefault(address, Collections.emptyList()), this.projectionFn);
        }

        public FileTraverser<R> traverser() throws Exception {
            this.updateConfiguration();
            return new HadoopFileTraverser<K, V, R>(this.configuration, ReadHadoopNewApiP.getSplits(this.configuration), this.projectionFn);
        }

        private void updateConfiguration() {
            this.configureFn.accept((Object)this.configuration);
        }

        public Permission getRequiredPermission() {
            return this.permission;
        }

        public boolean closeIsCooperative() {
            return true;
        }
    }
}

