/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.sources;

import com.hazelcast.jet.kafka.KafkaSources;
import com.hazelcast.jet.kafka.impl.HazelcastJsonValueDeserializer;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.pipeline.StreamSourceStage;
import com.hazelcast.pc.Source;
import com.hazelcast.pc.config.StageConfig;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.StringDeserializer;

public class KafkaSource
implements Source {
    public GeneralStage source(Pipeline pipeline, StageConfig stageConfig) {
        Properties props = KafkaSource.makeKafkaSourceProps(stageConfig);
        String topic = stageConfig.getRequiredValue("topic", String.class);
        StreamSource source = KafkaSources.kafka(props, topic);
        StreamSourceStage sourceStage = pipeline.readFrom(source);
        return Source.maybeApplyTimestamps(sourceStage, stageConfig);
    }

    private static String convertDeserializerType(String typeName) {
        if (typeName.equalsIgnoreCase("string")) {
            return StringDeserializer.class.getCanonicalName();
        }
        if (typeName.equalsIgnoreCase("json")) {
            return HazelcastJsonValueDeserializer.class.getCanonicalName();
        }
        return typeName;
    }

    private static Properties makeKafkaSourceProps(StageConfig stage) {
        String valuetype;
        String keyType;
        Properties kafkaProps = new Properties();
        Map props = stage.getOptionalValue("properties", Map.class);
        if (props != null) {
            kafkaProps.putAll((Map<?, ?>)props);
        }
        if ((keyType = stage.getRequiredValue("key-deserializer", String.class)) != null) {
            keyType = KafkaSource.convertDeserializerType(keyType);
            kafkaProps.put("key.deserializer", keyType);
        }
        if ((valuetype = stage.getRequiredValue("value-deserializer", String.class)) != null) {
            valuetype = KafkaSource.convertDeserializerType(valuetype);
            kafkaProps.put("value.deserializer", valuetype);
        }
        return kafkaProps;
    }
}

