/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.config;

import com.hazelcast.pc.exceptions.ConfigurationException;
import java.util.Map;

public class StageConfig {
    private final Map<String, Object> props;

    private StageConfig(Map<String, Object> props) {
        this.props = props;
    }

    public static StageConfig fromMap(Map<String, Object> props) {
        return new StageConfig(props);
    }

    public <T> T getRequiredValue(String key, Class<T> cls) {
        T value = this.getOptionalValue(key, cls);
        if (value == null) {
            throw new ConfigurationException(String.format("Required argument %s not found", key));
        }
        return value;
    }

    public <T> T getOptionalValue(String key, Class<T> cls) {
        if (this.props == null) {
            return null;
        }
        Object value = this.props.get(key);
        if (value == null) {
            return null;
        }
        if (cls.isInstance(value)) {
            return cls.cast(value);
        }
        throw new ConfigurationException(String.format("Field %s is not a %s", key, cls.getName()));
    }

    public String getType() {
        String name = this.getRequiredValue("type", String.class);
        return name.toLowerCase();
    }
}

