/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc.config;

import com.hazelcast.pc.config.PipelineConfig;
import com.hazelcast.pc.exceptions.PackageProcessorException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;

public class JetConfig {
    private PipelineConfig pipeline;

    public PipelineConfig getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(PipelineConfig pipeline) {
        this.pipeline = pipeline;
    }

    public static JetConfig fromPath(Path configPath) {
        JetConfig jetConfig;
        FileInputStream stream = new FileInputStream(configPath.toFile());
        try {
            jetConfig = JetConfig.fromStream(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PackageProcessorException(e);
            }
        }
        stream.close();
        return jetConfig;
    }

    public static JetConfig fromString(String definition) {
        LoaderOptions options = new LoaderOptions();
        Yaml yaml = new Yaml(new Constructor(JetConfig.class, options));
        try {
            return (JetConfig)yaml.load(definition);
        }
        catch (YAMLException e) {
            throw new PackageProcessorException(e);
        }
    }

    public static JetConfig fromStream(InputStream stream) {
        LoaderOptions options = new LoaderOptions();
        Yaml yaml = new Yaml(new Constructor(JetConfig.class, options));
        try {
            return (JetConfig)yaml.load(stream);
        }
        catch (YAMLException e) {
            throw new PackageProcessorException(e);
        }
    }
}

