/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.pc;

import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.Stage;
import com.hazelcast.pc.Sink;
import com.hazelcast.pc.Source;
import com.hazelcast.pc.Transform;
import com.hazelcast.pc.config.JetConfig;
import com.hazelcast.pc.config.PipelineConfig;
import com.hazelcast.pc.config.StageConfig;
import com.hazelcast.pc.exceptions.ConfigurationException;
import com.hazelcast.pc.sinks.JdbcSink;
import com.hazelcast.pc.sinks.KafkaSink;
import com.hazelcast.pc.sinks.LoggerSink;
import com.hazelcast.pc.sinks.MapSink;
import com.hazelcast.pc.sources.FileSource;
import com.hazelcast.pc.sources.ItemStreamSource;
import com.hazelcast.pc.sources.ItemsSource;
import com.hazelcast.pc.sources.JdbcSource;
import com.hazelcast.pc.sources.KafkaSource;
import com.hazelcast.pc.sources.MapJournalSource;
import com.hazelcast.pc.sources.MapSource;
import com.hazelcast.pc.transforms.PythonTransform;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class PipelineCreator {
    private static final Map<String, Source> SOURCES = new HashMap<String, Source>();
    private static final Map<String, Transform> TRANSFORMS = new HashMap<String, Transform>();
    private static final Map<String, Sink> SINKS = new HashMap<String, Sink>();
    private final JetConfig config;
    private final Path baseDir;

    private PipelineCreator(@Nonnull JetConfig config, Path baseDir) {
        this.config = config;
        this.baseDir = baseDir;
        PipelineConfig pipeline = config.getPipeline();
        if (pipeline == null) {
            throw new ConfigurationException("Pipeline configuration is not present");
        }
        if (pipeline.getSource() == null) {
            throw new ConfigurationException("Source stage is required but missing in the pipeline");
        }
        if (pipeline.getSink() == null) {
            throw new ConfigurationException("Sink stage is required but missing in the pipeline");
        }
    }

    public static PipelineCreator fromConfig(JetConfig config) {
        return new PipelineCreator(config, null);
    }

    public static PipelineCreator fromConfigWithBaseDir(@Nonnull JetConfig config, Path baseDir) {
        return new PipelineCreator(config, baseDir);
    }

    public Pipeline createPipeline() {
        Pipeline pipeline = Pipeline.create();
        Map<String, Object> sourceConfig = this.config.getPipeline().getSource();
        List<Map<String, Object>> transformConfigs = this.config.getPipeline().getTransform();
        Map<String, Object> sinkConfig = this.config.getPipeline().getSink();
        GeneralStage stage = this.createSourceStage(pipeline, sourceConfig);
        stage = this.createTransformStages(stage, transformConfigs);
        this.createSinkStage(stage, sinkConfig);
        return pipeline;
    }

    public static void registerSource(String type, Source source) {
        SOURCES.put(type, source);
    }

    public static void registerSink(String type, Sink sink) {
        SINKS.put(type, sink);
    }

    public static void registerTransform(String type, Transform transform) {
        TRANSFORMS.put(type, transform);
    }

    private GeneralStage createSourceStage(Pipeline pipeline, Map<String, Object> config) {
        StageConfig stageConfig = StageConfig.fromMap(config);
        Source source = SOURCES.get(stageConfig.getType());
        if (source == null) {
            throw new ConfigurationException(String.format("Unknown source: %s", stageConfig.getType()));
        }
        GeneralStage stage = source.source(pipeline, stageConfig);
        PipelineCreator.setNameOptionally(stageConfig, stage);
        return stage;
    }

    private static void setNameOptionally(StageConfig stageConfig, Stage stage) {
        String name = stageConfig.getOptionalValue("name", String.class);
        if (name != null) {
            stage.setName(name);
        }
    }

    private GeneralStage createTransformStages(GeneralStage stage, List<Map<String, Object>> configs) {
        if (configs == null) {
            return stage;
        }
        for (Map<String, Object> config : configs) {
            if (this.baseDir != null) {
                config.put("base_dir", this.baseDir.toAbsolutePath().toString());
            }
            stage = this.createTransformStage(stage, config);
        }
        return stage;
    }

    private GeneralStage createTransformStage(GeneralStage previousStage, Map<String, Object> config) {
        StageConfig stageConfig = StageConfig.fromMap(config);
        Transform transform = TRANSFORMS.get(stageConfig.getType());
        if (transform == null) {
            throw new ConfigurationException(String.format("Unknown transform: %s", stageConfig.getType()));
        }
        GeneralStage transformStage = transform.transform(previousStage, stageConfig);
        PipelineCreator.setNameOptionally(stageConfig, transformStage);
        return transformStage;
    }

    private void createSinkStage(Object previousStage, Map<String, Object> config) {
        StageConfig stageConfig = StageConfig.fromMap(config);
        Sink sink = SINKS.get(stageConfig.getType());
        if (sink == null) {
            throw new ConfigurationException(String.format("Unknown sink: %s", stageConfig.getType()));
        }
        SinkStage sinkStage = sink.sink(previousStage, stageConfig);
        PipelineCreator.setNameOptionally(stageConfig, (Stage)sinkStage);
    }

    static {
        PipelineCreator.registerSource("file", new FileSource());
        PipelineCreator.registerSource("item-stream", new ItemStreamSource());
        PipelineCreator.registerSource("items", new ItemsSource());
        PipelineCreator.registerSource("jdbc", new JdbcSource());
        PipelineCreator.registerSource("kafka", new KafkaSource());
        PipelineCreator.registerSource("map", new MapSource());
        PipelineCreator.registerSource("map-journal", new MapJournalSource());
        PipelineCreator.registerSink("jdbc", new JdbcSink());
        PipelineCreator.registerSink("kafka", new KafkaSink());
        PipelineCreator.registerSink("logger", new LoggerSink());
        PipelineCreator.registerSink("map", new MapSink());
        PipelineCreator.registerTransform("python", new PythonTransform());
    }
}

