/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TopicsConfig
implements Serializable {
    private static final ILogger LOGGER = Logger.getLogger(TopicsConfig.class);
    private static final long serialVersionUID = 1L;
    private final Map<String, TopicConfig> topicConfigs = new LinkedHashMap<String, TopicConfig>();

    public Map<String, TopicConfig> getTopicConfigs() {
        return Collections.unmodifiableMap(this.topicConfigs);
    }

    public Set<String> getTopicNames() {
        return this.topicConfigs.keySet();
    }

    @Nullable
    public TopicConfig getTopicConfig(String topicName) {
        return this.topicConfigs.get(topicName);
    }

    public TopicsConfig addTopicConfig(TopicConfig config) {
        TopicConfig oldConfig = this.topicConfigs.put(config.topicName, config);
        if (oldConfig != null) {
            LOGGER.warning("Duplicate topic configs for topic: '" + config.topicName + "' found, the last added one will be used");
        }
        return this;
    }

    public TopicsConfig addTopic(String topicName) {
        this.addTopicConfig(new TopicConfig(topicName));
        return this;
    }

    public TopicsConfig addTopics(List<String> topicNames) {
        for (String topicName : topicNames) {
            this.addTopicConfig(new TopicConfig(topicName));
        }
        return this;
    }

    @Nullable
    public Long getInitialOffsetFor(String topicName, int partition) {
        TopicConfig topicConfig = this.topicConfigs.get(topicName);
        if (topicConfig == null) {
            return null;
        }
        return topicConfig.getPartitionInitialOffset(partition);
    }

    public String toString() {
        return "TopicsConfig{topicConfigs=" + String.valueOf(this.topicConfigs) + "}";
    }

    public static class TopicConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String topicName;
        private final Map<Integer, Long> partitionsInitialOffsets = new HashMap<Integer, Long>();

        public TopicConfig(@Nonnull String topicName) {
            Preconditions.checkNotNull((Object)topicName);
            this.topicName = topicName;
        }

        public String getTopicName() {
            return this.topicName;
        }

        public Map<Integer, Long> getPartitionsInitialOffsets() {
            return Collections.unmodifiableMap(this.partitionsInitialOffsets);
        }

        @Nullable
        public Long getPartitionInitialOffset(int partition) {
            return this.partitionsInitialOffsets.get(partition);
        }

        public TopicConfig addPartitionInitialOffset(int partition, long offset) {
            this.partitionsInitialOffsets.put(partition, offset);
            return this;
        }

        public String toString() {
            return "TopicConfig{topicName=" + this.topicName + ", partitionsInitialOffsets=" + String.valueOf(this.partitionsInitialOffsets) + "}";
        }
    }
}

