/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.kafka.TopicsConfig;
import com.hazelcast.jet.kafka.impl.StreamKafkaP;
import com.hazelcast.jet.kafka.impl.WriteKafkaP;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaProcessors {
    private KafkaProcessors() {
    }

    public static <K, V, T> ProcessorMetaSupplier streamKafkaP(@Nonnull Properties properties, @Nonnull FunctionEx<? super ConsumerRecord<K, V>, ? extends T> projectionFn, @Nonnull EventTimePolicy<? super T> eventTimePolicy, String ... topics) {
        Preconditions.checkPositive((double)topics.length, (String)"At least one topic must be supplied");
        TopicsConfig topicsConfig = new TopicsConfig().addTopics(Arrays.asList(topics));
        return ProcessorMetaSupplier.of((int)4, StreamKafkaP.processorSupplier((FunctionEx & Serializable)c -> new KafkaConsumer(properties), topicsConfig, projectionFn, eventTimePolicy));
    }

    public static <K, V, T> ProcessorMetaSupplier streamKafkaP(@Nonnull Properties properties, @Nonnull FunctionEx<? super ConsumerRecord<K, V>, ? extends T> projectionFn, @Nonnull EventTimePolicy<? super T> eventTimePolicy, @Nonnull TopicsConfig topicsConfig) {
        Preconditions.checkPositive((double)topicsConfig.getTopicNames().size(), (String)"At least one topic must be supplied");
        return ProcessorMetaSupplier.of((int)4, StreamKafkaP.processorSupplier((FunctionEx & Serializable)c -> new KafkaConsumer(properties), topicsConfig, projectionFn, eventTimePolicy));
    }

    public static <K, V, T> ProcessorMetaSupplier streamKafkaP(@Nonnull DataConnectionRef dataConnectionRef, @Nonnull FunctionEx<? super ConsumerRecord<K, V>, ? extends T> projectionFn, @Nonnull EventTimePolicy<? super T> eventTimePolicy, String ... topics) {
        Preconditions.checkPositive((double)topics.length, (String)"At least one topic must be supplied");
        TopicsConfig topicsConfig = new TopicsConfig().addTopics(Arrays.asList(topics));
        return ProcessorMetaSupplier.of((int)4, StreamKafkaP.processorSupplier(StreamKafkaP.kafkaConsumerFn(dataConnectionRef), topicsConfig, projectionFn, eventTimePolicy));
    }

    public static <T, K, V> ProcessorMetaSupplier writeKafkaP(@Nonnull Properties properties, @Nonnull String topic, @Nonnull FunctionEx<? super T, ? extends K> extractKeyFn, @Nonnull FunctionEx<? super T, ? extends V> extractValueFn, boolean exactlyOnce) {
        return KafkaProcessors.writeKafkaP(properties, (FunctionEx & Serializable)t -> new ProducerRecord<Object, Object>(topic, extractKeyFn.apply(t), extractValueFn.apply(t)), exactlyOnce);
    }

    public static <T, K, V> ProcessorMetaSupplier writeKafkaP(@Nonnull DataConnectionRef dataConnectionRef, @Nonnull String topic, @Nonnull FunctionEx<? super T, ? extends K> extractKeyFn, @Nonnull FunctionEx<? super T, ? extends V> extractValueFn, boolean exactlyOnce) {
        return KafkaProcessors.writeKafkaP(dataConnectionRef, (FunctionEx & Serializable)t -> new ProducerRecord<Object, Object>(topic, extractKeyFn.apply(t), extractValueFn.apply(t)), exactlyOnce);
    }

    public static <T, K, V> ProcessorMetaSupplier writeKafkaP(@Nonnull DataConnectionRef dataConnectionRef, @Nonnull Properties properties, @Nonnull String topic, @Nonnull FunctionEx<? super T, ? extends K> extractKeyFn, @Nonnull FunctionEx<? super T, ? extends V> extractValueFn, boolean exactlyOnce) {
        return KafkaProcessors.writeKafkaP(dataConnectionRef, properties, (FunctionEx & Serializable)t -> new ProducerRecord<Object, Object>(topic, extractKeyFn.apply(t), extractValueFn.apply(t)), exactlyOnce);
    }

    public static <T, K, V> ProcessorMetaSupplier writeKafkaP(@Nonnull Properties properties, @Nonnull FunctionEx<? super T, ? extends ProducerRecord<K, V>> toRecordFn, boolean exactlyOnce) {
        return ProcessorMetaSupplier.of((int)1, WriteKafkaP.supplier(properties, toRecordFn, exactlyOnce));
    }

    public static <T, K, V> ProcessorMetaSupplier writeKafkaP(@Nonnull DataConnectionRef dataConnectionRef, @Nonnull FunctionEx<? super T, ? extends ProducerRecord<K, V>> toRecordFn, boolean exactlyOnce) {
        return ProcessorMetaSupplier.of((int)1, (ProcessorSupplier)WriteKafkaP.supplier(dataConnectionRef, toRecordFn, exactlyOnce));
    }

    public static <T, K, V> ProcessorMetaSupplier writeKafkaP(@Nonnull DataConnectionRef dataConnectionRef, @Nonnull Properties properties, @Nonnull FunctionEx<? super T, ? extends ProducerRecord<K, V>> toRecordFn, boolean exactlyOnce) {
        return ProcessorMetaSupplier.of((int)1, (ProcessorSupplier)WriteKafkaP.supplier(dataConnectionRef, properties, toRecordFn, exactlyOnce));
    }
}

