/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.dataconnection.DataConnectionBase;
import com.hazelcast.dataconnection.DataConnectionResource;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.kafka.impl.NonClosingKafkaProducer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;

public class KafkaDataConnection
extends DataConnectionBase {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private volatile ConcurrentMemoizingSupplier<NonClosingKafkaProducer<?, ?>> producerSupplier = new ConcurrentMemoizingSupplier(() -> new NonClosingKafkaProducer(config.getProperties(), () -> ((KafkaDataConnection)this).release()));

    public KafkaDataConnection(@Nonnull DataConnectionConfig config) {
        super(config);
    }

    @Nonnull
    public Collection<DataConnectionResource> listResources() {
        Collection collection;
        block8: {
            AdminClient client = AdminClient.create(this.getConfig().getProperties());
            try {
                collection = client.listTopics().names().get().stream().sorted().map(n -> new DataConnectionResource("topic", n)).collect(Collectors.toList());
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new HazelcastException("Could not get list of topics for DataConnection " + this.getConfig().getName(), (Throwable)e);
                }
            }
            client.close();
        }
        return collection;
    }

    @Nonnull
    public Collection<String> resourceTypes() {
        return Collections.singleton("Topic");
    }

    @Nonnull
    public <K, V> Consumer<K, V> newConsumer() {
        return this.newConsumer(EMPTY_PROPERTIES);
    }

    @Nonnull
    public <K, V> Consumer<K, V> newConsumer(Properties properties) {
        if (this.getConfig().isShared()) {
            throw new IllegalArgumentException("KafkaConsumer is not thread-safe and can't be used with shared DataConnection '" + this.getConfig().getName() + "'");
        }
        return new KafkaConsumer(Util.mergeProps((Properties)this.getConfig().getProperties(), (Properties)properties));
    }

    @Nonnull
    public <K, V> KafkaProducer<K, V> getProducer(@Nullable String transactionalId) {
        if (this.getConfig().isShared()) {
            if (transactionalId != null) {
                throw new IllegalArgumentException("Cannot use transactions with shared KafkaProducer for DataConnection" + this.getConfig().getName());
            }
            this.retain();
            return (KafkaProducer)this.producerSupplier.get();
        }
        if (transactionalId != null) {
            Properties castProperties = this.getConfig().getProperties();
            HashMap<Object, Object> copy = new HashMap<Object, Object>(castProperties);
            copy.put("transactional.id", transactionalId);
            return new KafkaProducer(copy);
        }
        return new KafkaProducer(this.getConfig().getProperties());
    }

    @Nonnull
    public <K, V> KafkaProducer<K, V> getProducer(@Nullable String transactionalId, @Nonnull Properties properties) {
        Properties configProperties = this.getConfig().getProperties();
        boolean inputPropsAreSubsetOfConfigProps = this.inputPropsAreSubsetOfConfigProps(properties);
        if (this.getConfig().isShared()) {
            if (!properties.isEmpty() && !inputPropsAreSubsetOfConfigProps) {
                throw new HazelcastException("For shared Kafka producer, please provide all serialization optionsat the DATA CONNECTION level (i.e. 'key.serializer'). Only 'keyFormat' and 'valueFormat' are required at the mapping level, however these options are ignored currently.");
            }
            this.retain();
            return (KafkaProducer)this.producerSupplier.get();
        }
        Properties props = Util.mergeProps((Properties)configProperties, (Properties)properties);
        if (transactionalId != null) {
            props.put("transactional.id", transactionalId);
        }
        return new KafkaProducer(props);
    }

    public synchronized void destroy() {
        if (this.producerSupplier != null && this.producerSupplier.remembered() != null) {
            ((NonClosingKafkaProducer)this.producerSupplier.remembered()).doClose();
            this.producerSupplier = null;
        }
    }

    private boolean inputPropsAreSubsetOfConfigProps(Properties inputProps) {
        Properties configProperties = this.getConfig().getProperties();
        for (Object key : inputProps.keySet()) {
            if (configProperties.containsKey(key) && configProperties.get(key).equals(inputProps.get(key))) continue;
            return false;
        }
        return true;
    }
}

