/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type;

import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.math.MathContext;
import java.math.RoundingMode;

public final class QueryDataTypeUtils {
    public static final int TYPE_LEN_VARCHAR = 56;
    public static final int TYPE_LEN_DECIMAL = 112;
    public static final int TYPE_LEN_TIME = 24;
    public static final int TYPE_LEN_DATE = 24;
    public static final int TYPE_LEN_TIMESTAMP = 72;
    public static final int TYPE_LEN_TIMESTAMP_WITH_TIME_ZONE = 168;
    public static final int TYPE_LEN_INTERVAL_YEAR_MONTH = 16;
    public static final int TYPE_LEN_INTERVAL_DAY_SECOND = 24;
    public static final int TYPE_LEN_MAP = 48;
    public static final int TYPE_LEN_JSON = 72;
    public static final int TYPE_LEN_OBJECT = 48;
    public static final int TYPE_LEN_ROW = 48;
    public static final int TYPE_LEN_NULL = 1;
    public static final int PRECEDENCE_NULL = 0;
    public static final int PRECEDENCE_VARCHAR = 100;
    public static final int PRECEDENCE_BOOLEAN = 200;
    public static final int PRECEDENCE_TINYINT = 300;
    public static final int PRECEDENCE_SMALLINT = 400;
    public static final int PRECEDENCE_INTEGER = 500;
    public static final int PRECEDENCE_BIGINT = 600;
    public static final int PRECEDENCE_DECIMAL = 700;
    public static final int PRECEDENCE_REAL = 800;
    public static final int PRECEDENCE_DOUBLE = 900;
    public static final int PRECEDENCE_TIME = 1000;
    public static final int PRECEDENCE_DATE = 1100;
    public static final int PRECEDENCE_TIMESTAMP = 1200;
    public static final int PRECEDENCE_TIMESTAMP_WITH_TIME_ZONE = 1300;
    public static final int PRECEDENCE_OBJECT = 1400;
    public static final int PRECEDENCE_INTERVAL_YEAR_MONTH = 10;
    public static final int PRECEDENCE_INTERVAL_DAY_SECOND = 20;
    public static final int PRECEDENCE_MAP = 30;
    public static final int PRECEDENCE_JSON = 40;
    public static final int PRECEDENCE_ROW = 50;
    public static final MathContext DECIMAL_MATH_CONTEXT = new MathContext(76, RoundingMode.HALF_UP);

    private QueryDataTypeUtils() {
    }

    public static QueryDataType resolveTypeForClass(Class<?> clazz) {
        Converter converter = Converters.getConverter(clazz);
        QueryDataType type = QueryDataType.resolveForConverter(converter);
        if (type == null) {
            throw new IllegalArgumentException("Unexpected class: " + String.valueOf(clazz));
        }
        return type;
    }

    public static QueryDataType resolveTypeForTypeFamily(QueryDataTypeFamily typeFamily) {
        switch (typeFamily) {
            case VARCHAR: {
                return QueryDataType.VARCHAR;
            }
            case BOOLEAN: {
                return QueryDataType.BOOLEAN;
            }
            case TINYINT: {
                return QueryDataType.TINYINT;
            }
            case SMALLINT: {
                return QueryDataType.SMALLINT;
            }
            case INTEGER: {
                return QueryDataType.INT;
            }
            case BIGINT: {
                return QueryDataType.BIGINT;
            }
            case DECIMAL: {
                return QueryDataType.DECIMAL;
            }
            case REAL: {
                return QueryDataType.REAL;
            }
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
            case DATE: {
                return QueryDataType.DATE;
            }
            case TIME: {
                return QueryDataType.TIME;
            }
            case TIMESTAMP: {
                return QueryDataType.TIMESTAMP;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
            }
            case OBJECT: {
                return QueryDataType.OBJECT;
            }
            case NULL: {
                return QueryDataType.NULL;
            }
            case JSON: {
                return QueryDataType.JSON;
            }
            case ROW: {
                return QueryDataType.ROW;
            }
        }
        throw new IllegalArgumentException("Unexpected type family: " + String.valueOf((Object)typeFamily));
    }

    public static boolean isNumeric(QueryDataType type) {
        return QueryDataTypeUtils.isNumeric(type.getTypeFamily());
    }

    public static boolean isNumeric(QueryDataTypeFamily typeFamily) {
        switch (typeFamily) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }
}

