/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.dataconnection;

import com.hazelcast.dataconnection.impl.DataConnectionServiceImpl;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.parse.SqlCreateDataConnection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.schema.SqlCatalogObject;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DataConnectionCatalogEntry
implements SqlCatalogObject {
    private String name;
    private String type;
    private boolean shared;
    private Map<String, String> options;
    private DataConnectionServiceImpl.DataConnectionSource source;

    public DataConnectionCatalogEntry() {
    }

    public DataConnectionCatalogEntry(String name, String type, boolean shared, Map<String, String> options) {
        this.name = name;
        this.type = type;
        this.shared = shared;
        this.options = options;
        this.source = DataConnectionServiceImpl.DataConnectionSource.SQL;
    }

    public DataConnectionCatalogEntry(String name, String type, boolean shared, Map<String, String> options, DataConnectionServiceImpl.DataConnectionSource source) {
        this.name = name;
        this.shared = shared;
        this.type = type;
        this.options = options;
        this.source = source;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Nonnull
    public String type() {
        return this.type;
    }

    public boolean isShared() {
        return this.shared;
    }

    @Nonnull
    public Map<String, String> options() {
        return this.options;
    }

    @Nonnull
    public DataConnectionServiceImpl.DataConnectionSource source() {
        return this.source;
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.shared = in.readBoolean();
        this.options = (Map)in.readObject();
        this.source = (DataConnectionServiceImpl.DataConnectionSource)in.readObject();
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.shared);
        out.writeObject(this.options);
        out.writeObject((Object)this.source);
    }

    @Override
    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 79;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataConnectionCatalogEntry e = (DataConnectionCatalogEntry)o;
        return this.shared == e.shared && this.name.equals(e.name) && this.type.equals(e.type) && this.options.equals(e.options) && this.source == e.source;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.shared, this.options, this.source);
    }

    @Override
    @Nonnull
    public String unparse() {
        return SqlCreateDataConnection.unparse(this);
    }
}

