/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.SqlCatalogObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Mapping
implements SqlCatalogObject,
Versioned {
    private String name;
    private String[] externalName;
    private String dataConnection;
    private String connectorType;
    private String objectType;
    private List<MappingField> mappingFields;
    private Map<String, String> options;

    public Mapping() {
    }

    public Mapping(String name, String externalName, String dataConnection, String connectorType, String objectType, List<MappingField> fields, Map<String, String> options) {
        this(name, new String[]{externalName}, dataConnection, connectorType, objectType, fields, options);
    }

    public Mapping(String name, String[] externalName, String dataConnection, String connectorType, String objectType, List<MappingField> fields, Map<String, String> options) {
        assert (connectorType == null || dataConnection == null);
        this.name = name;
        this.externalName = externalName;
        this.dataConnection = dataConnection;
        this.connectorType = connectorType;
        this.objectType = objectType;
        this.mappingFields = fields;
        this.options = options;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String[] externalName() {
        return this.externalName;
    }

    public String connectorType() {
        return this.connectorType;
    }

    public String dataConnection() {
        return this.dataConnection;
    }

    public String objectType() {
        return this.objectType;
    }

    public List<MappingField> fields() {
        return Collections.unmodifiableList(this.mappingFields);
    }

    public Map<String, String> options() {
        return Collections.unmodifiableMap(this.options);
    }

    public int getClassId() {
        return 57;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            out.writeStringArray(this.externalName);
        } else {
            out.writeString(this.externalName[0]);
        }
        out.writeString(this.connectorType);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            out.writeString(this.dataConnection);
            out.writeString(this.objectType);
        }
        out.writeObject(this.mappingFields);
        out.writeObject(this.options);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.externalName = in.getVersion().isGreaterOrEqual(Versions.V5_3) ? in.readStringArray() : new String[]{in.readString()};
        this.connectorType = in.readString();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            this.dataConnection = in.readString();
            this.objectType = in.readString();
        }
        this.mappingFields = (List)in.readObject();
        this.options = (Map)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mapping mapping = (Mapping)o;
        return Objects.equals(this.name, mapping.name) && Arrays.equals(this.externalName, mapping.externalName) && Objects.equals(this.dataConnection, mapping.dataConnection) && Objects.equals(this.connectorType, mapping.connectorType) && Objects.equals(this.objectType, mapping.objectType) && Objects.equals(this.mappingFields, mapping.mappingFields) && Objects.equals(this.options, mapping.options);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.externalName, this.dataConnection, this.connectorType, this.objectType, this.mappingFields, this.options);
    }

    @Override
    @Nonnull
    public String unparse() {
        return SqlCreateMapping.unparse(this);
    }
}

