/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.datetime;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.sql.impl.expression.ConcurrentInitialSetCache;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.TriExpression;
import com.hazelcast.sql.impl.expression.datetime.Formatter;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.temporal.Temporal;
import java.util.Locale;

public class ToCharFunction
extends TriExpression<String> {
    private static final int CACHE_SIZE = 100;
    private transient ConcurrentInitialSetCache<String, Formatter> formatterCache;
    private transient ConcurrentInitialSetCache<String, Locale> localeCache;

    public ToCharFunction() {
    }

    private ToCharFunction(Expression<?> input, Expression<?> format, Expression<?> locale) {
        super(input, format, locale);
        this.prepareCache();
    }

    public static ToCharFunction create(Expression<?> input, Expression<?> format, Expression<?> locale) {
        return new ToCharFunction(input, format, locale);
    }

    public int getClassId() {
        return 31;
    }

    @Override
    public String eval(Row row, ExpressionEvalContext context) {
        Object input = this.operand1.eval(row, context);
        String format = (String)this.operand2.eval(row, context);
        Formatter formatter = this.formatterCache.computeIfAbsent(format, input instanceof Temporal ? Formatter::forDates : Formatter::forNumbers);
        Locale locale = this.operand3 == null ? Locale.US : this.localeCache.computeIfAbsent((String)this.operand3.eval(row, context), Locale::forLanguageTag);
        return formatter.format(input, locale);
    }

    private void prepareCache() {
        this.formatterCache = new ConcurrentInitialSetCache(100);
        this.localeCache = new ConcurrentInitialSetCache(100);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.VARCHAR;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.prepareCache();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.prepareCache();
    }
}

