/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.datetime;

import com.hazelcast.sql.impl.QueryException;
import java.text.DecimalFormatSymbols;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.JulianFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public abstract class Formatter {
    private static final String ESCAPED = "\\\\.";
    private static final String LITERAL = "\"(?:\\\\.|[^\"])*\"?|\\\\.";
    private static final String DATETIME = "SSSSS?|HH(?:12|24)?|MI|[SMU]S|FF[1-6]|[AP](?:M|\\.M\\.)|DA?Y|Da?y|I?DDD|DD|I?D|J|W|[WI]W|MON(?:TH)?|Mon(?:th)?|MM|Y,YYY|[YI]Y{0,3}|Q|CC|BC|B\\.C\\.|AD|A\\.D\\.|R[DMY]|r[dmy]|TZ[HM]?|TZ|OF";
    private static final String NUMERIC = "[,G.D]|FM|BR?|SG?|MI?|PL?|CR?|V9+|TH|EEEE|RN";
    private static final Pattern DATETIME_TEMPLATE = Pattern.compile("((?:FM|fm|TM|tm)*)(SSSSS?|HH(?:12|24)?|MI|[SMU]S|FF[1-6]|[AP](?:M|\\.M\\.)|DA?Y|Da?y|I?DDD|DD|I?D|J|W|[WI]W|MON(?:TH)?|Mon(?:th)?|MM|Y,YYY|[YI]Y{0,3}|Q|CC|BC|B\\.C\\.|AD|A\\.D\\.|R[DMY]|r[dmy]|TZ[HM]?|TZ|OF|" + "SSSSS?|HH(?:12|24)?|MI|[SMU]S|FF[1-6]|[AP](?:M|\\.M\\.)|DA?Y|Da?y|I?DDD|DD|I?D|J|W|[WI]W|MON(?:TH)?|Mon(?:th)?|MM|Y,YYY|[YI]Y{0,3}|Q|CC|BC|B\\.C\\.|AD|A\\.D\\.|R[DMY]|r[dmy]|TZ[HM]?|TZ|OF".toLowerCase() + ")(TH|th)?|\"(?:\\\\.|[^\"])*\"?|\\\\.");
    private static final Pattern NUMERIC_TEMPLATE = Pattern.compile("[90]+|[,G.D]|FM|BR?|SG?|MI?|PL?|CR?|V9+|TH|EEEE|RN|" + "[,G.D]|FM|BR?|SG?|MI?|PL?|CR?|V9+|TH|EEEE|RN".toLowerCase() + "|[Ff]?\"(?:\\\\.|[^\"])*\"?|\\\\.");
    private static final Pattern SIGN = Pattern.compile("[+-]");
    private static final int[] ARABIC = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final String[] ORDINAL = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};

    public static Formatter forDates(@Nonnull String format) {
        return new DateFormat(format);
    }

    public static Formatter forNumbers(@Nonnull String format) {
        return new NumberFormat(format);
    }

    public abstract String format(@Nonnull Object var1, @Nonnull Locale var2);

    private static void parse(Pattern template, GroupProcessor processor, String format) {
        Matcher m4 = template.matcher(format);
        StringBuilder literal = new StringBuilder();
        int i = 0;
        while (m4.find()) {
            String group;
            if (m4.start() > i) {
                literal.append(format, i, m4.start());
            }
            if ((group = m4.group()).startsWith("\\")) {
                literal.append(group);
            } else {
                if (literal.length() > 0) {
                    processor.acceptLiteral(literal.toString());
                    literal.setLength(0);
                }
                processor.acceptGroup(group, m4);
            }
            i = m4.end();
        }
        if (i < m4.regionEnd() || literal.length() > 0) {
            processor.acceptLiteral(String.valueOf(literal) + format.substring(i));
        }
    }

    private static <T extends Enum<T>> T valueOf(Class<T> type, String name) {
        try {
            return Enum.valueOf(type, name);
        }
        catch (IllegalArgumentException e) {
            return Enum.valueOf(type, name.toUpperCase());
        }
    }

    private static String unescape(String input) {
        StringBuilder s2 = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') continue;
            if (c == '\\' && ++i < input.length()) {
                c = input.charAt(i);
            }
            s2.append(c);
        }
        return s2.toString();
    }

    private static String toRoman(int number) {
        StringBuilder s2 = new StringBuilder(15);
        if (number > 3999) {
            for (int i = 0; i < 15; ++i) {
                s2.append('#');
            }
        } else {
            for (int i = 0; i < ARABIC.length; ++i) {
                while (number >= ARABIC[i]) {
                    s2.append(ROMAN[i]);
                    number -= ARABIC[i];
                }
            }
        }
        return s2.toString();
    }

    private static String getOrdinal(String number) {
        return number.endsWith("11") || number.endsWith("12") || number.endsWith("13") ? "th" : ORDINAL[number.charAt(number.length() - 1) - 48];
    }

    private static class DateFormat
    extends Formatter {
        static final DateTimeFormatter MERIDIEM_FORMATTER = DateTimeFormatter.ofPattern("a");
        static final DateTimeFormatter TIMEZONE_FORMATTER = DateTimeFormatter.ofPattern("O");
        static final DateTimeFormatter ERA_FORMATTER = DateTimeFormatter.ofPattern("G");
        static final BiFunction<Object, Locale, Object> UPPERCASE = (o, l) -> ((String)o).toUpperCase((Locale)l);
        static final BiFunction<Object, Locale, Object> LOWERCASE = (o, l) -> ((String)o).toLowerCase((Locale)l);
        static final BiFunction<Object, Locale, Object> WITH_PERIODS = (o, l) -> {
            String r = (String)o;
            return r.length() != 2 ? r : r.charAt(0) + "." + r.charAt(1) + ".";
        };
        private final List<Part> parts = new ArrayList<Part>();

        DateFormat(String format) {
            Formatter.parse(DATETIME_TEMPLATE, new DateTimeGroupProcessor(), format);
        }

        @Override
        public String format(@Nonnull Object input, @Nonnull Locale locale) {
            if (!(input instanceof Temporal)) {
                throw QueryException.dataException((String)"Input parameter is expected to be date/time");
            }
            StringBuilder s2 = new StringBuilder();
            this.parts.forEach(p -> p.format(s2, (Temporal)input, locale));
            return s2.toString();
        }

        public String toString() {
            return this.parts.toString();
        }

        class DateTimeGroupProcessor
        implements GroupProcessor {
            DateTimeGroupProcessor() {
            }

            @Override
            public void acceptLiteral(String literal) {
                DateFormat.this.parts.add(new Literal(literal));
            }

            @Override
            public void acceptGroup(String group, Matcher m4) {
                if (group.startsWith("\"")) {
                    DateFormat.this.parts.add(new Literal(group));
                } else {
                    String prefix = m4.group(1).toUpperCase();
                    String pattern = m4.group(2).replace('.', '_').replace(',', '_');
                    String suffix = m4.group(3);
                    DateFormat.this.parts.add(new PatternInstance(!prefix.contains("FM"), Formatter.valueOf(PatternElement.class, pattern), suffix == null ? null : Ordinal.valueOf(suffix)));
                }
            }
        }

        static interface Part {
            public void format(StringBuilder var1, Temporal var2, Locale var3);
        }

        static enum Ordinal {
            TH,
            th;

        }

        static enum PatternElement {
            HH12(ChronoField.CLOCK_HOUR_OF_AMPM, 2),
            HH(HH12),
            HH24(ChronoField.HOUR_OF_DAY, 2),
            MI(ChronoField.MINUTE_OF_HOUR, 2),
            SS(ChronoField.SECOND_OF_MINUTE, 2),
            MS(ChronoField.MILLI_OF_SECOND, 3),
            US(ChronoField.MICRO_OF_SECOND, 6),
            FF1(MS, (r, l) -> (Integer)r / 100, 1),
            FF2(MS, (r, l) -> (Integer)r / 10, 2),
            FF3(MS),
            FF4(US, (r, l) -> (Integer)r / 100, 4),
            FF5(US, (r, l) -> (Integer)r / 10, 5),
            FF6(US),
            SSSS(ChronoField.SECOND_OF_DAY, 5),
            SSSSS(SSSS),
            AM((t2, l) -> MERIDIEM_FORMATTER.withLocale((Locale)l).format((TemporalAccessor)t2), 2),
            PM(AM),
            am(AM, LOWERCASE),
            pm(am),
            A_M_(AM, WITH_PERIODS, 4),
            P_M_(A_M_),
            a_m_(am, WITH_PERIODS),
            p_m_(a_m_),
            YYYY(ChronoField.YEAR_OF_ERA, 4),
            Y_YYY(YYYY),
            YYY(YYYY, (r, l) -> (Integer)r % 1000, 3),
            YY(YYYY, (r, l) -> (Integer)r % 100, 2),
            Y(YYYY, (r, l) -> (Integer)r % 10, 1),
            IYYY(WeekFields.ISO.weekBasedYear(), 4),
            IYY(IYYY, (r, l) -> (Integer)r % 1000, 3),
            IY(IYYY, (r, l) -> (Integer)r % 100, 2),
            I(IYYY, (r, l) -> (Integer)r % 10, 1),
            BC((t2, l) -> ERA_FORMATTER.withLocale((Locale)l).format((TemporalAccessor)t2), 2),
            AD(BC),
            bc(BC, LOWERCASE),
            ad(bc),
            B_C_(BC, WITH_PERIODS, 4),
            A_D_(B_C_),
            b_c_(bc, WITH_PERIODS),
            a_d_(b_c_),
            Month((t2, l) -> java.time.Month.from(t2).getDisplayName(TextStyle.FULL, (Locale)l), 9),
            MONTH(Month, UPPERCASE),
            month(Month, LOWERCASE),
            Mon((t2, l) -> java.time.Month.from(t2).getDisplayName(TextStyle.SHORT, (Locale)l), 3),
            MON(Mon, UPPERCASE),
            mon(Mon, LOWERCASE),
            MM(ChronoField.MONTH_OF_YEAR, 2),
            Day((t2, l) -> DayOfWeek.from(t2).getDisplayName(TextStyle.FULL, (Locale)l), 9),
            DAY(Day, UPPERCASE),
            day(Day, LOWERCASE),
            Dy((t2, l) -> DayOfWeek.from(t2).getDisplayName(TextStyle.SHORT, (Locale)l), 3),
            DY(Dy, UPPERCASE),
            dy(Dy, LOWERCASE),
            DDD(ChronoField.DAY_OF_YEAR, 3),
            IDDD((t2, l) -> (t2.get(WeekFields.ISO.weekOfWeekBasedYear()) - 1) * 7 + t2.get(WeekFields.ISO.dayOfWeek()), 3),
            DD(ChronoField.DAY_OF_MONTH, 2),
            D(ChronoField.DAY_OF_WEEK, 1),
            ID(WeekFields.ISO.dayOfWeek(), 1),
            W(ChronoField.ALIGNED_WEEK_OF_MONTH, 1),
            WW(ChronoField.ALIGNED_WEEK_OF_YEAR, 2),
            IW(WeekFields.ISO.weekOfWeekBasedYear(), 2),
            CC((t2, l) -> (int)Math.ceil((float)t2.get(ChronoField.YEAR_OF_ERA) / 100.0f), 2),
            J((t2, l) -> t2.getLong(JulianFields.JULIAN_DAY), 7),
            Q(IsoFields.QUARTER_OF_YEAR, 1),
            RY((t2, l) -> Formatter.toRoman(t2.get(ChronoField.YEAR_OF_ERA)), 15),
            ry(RY, LOWERCASE),
            RM((t2, l) -> Formatter.toRoman(t2.get(ChronoField.MONTH_OF_YEAR)), 4),
            rm(RM, LOWERCASE),
            RD((t2, l) -> Formatter.toRoman(t2.get(ChronoField.DAY_OF_MONTH)), 6),
            rd(RD, LOWERCASE),
            TZ((t2, l) -> SIGN.split(TIMEZONE_FORMATTER.withLocale((Locale)l).format((TemporalAccessor)t2))[0], 3),
            tz(TZ, LOWERCASE),
            TZH((t2, l) -> ZoneOffset.from(t2).getTotalSeconds() / 3600, 2),
            TZM((t2, l) -> ZoneOffset.from(t2).getTotalSeconds() % 3600 / 60, 2),
            OF((t2, l) -> ZoneOffset.from(t2).getId(), 6);

            final BiFunction<Temporal, Locale, Object> query;
            final int maxLength;

            private PatternElement(PatternElement pattern) {
                this(pattern.query, pattern.maxLength);
            }

            private PatternElement(TemporalField field, int maxLength) {
                this((Temporal t2, Locale l) -> t2.get(field), maxLength);
            }

            private PatternElement(PatternElement pattern, BiFunction<Object, Locale, Object> transform) {
                this(pattern, transform, pattern.maxLength);
            }

            private PatternElement(PatternElement pattern, BiFunction<Object, Locale, Object> transform, int maxLength) {
                this((Temporal t2, Locale l) -> transform.apply(pattern.query.apply((Temporal)t2, (Locale)l), (Locale)l), maxLength);
            }

            private PatternElement(BiFunction<Temporal, Locale, Object> query, int maxLength) {
                this.query = query;
                this.maxLength = maxLength;
            }
        }

        static class PatternInstance
        implements Part {
            final boolean padding;
            final PatternElement pattern;
            final Ordinal ordinal;

            PatternInstance(boolean padding, PatternElement pattern, Ordinal ordinal) {
                this.padding = padding;
                this.pattern = pattern;
                this.ordinal = ordinal;
            }

            @Override
            public void format(StringBuilder s2, Temporal input, Locale locale) {
                Object result = this.pattern.query.apply(input, locale);
                String r = result.toString();
                if (this.pattern == PatternElement.TZH) {
                    s2.append((Integer)result < 0 ? (char)'-' : '+');
                    String string = r = (Integer)result < 0 ? r.substring(1) : r;
                }
                if (this.padding) {
                    char pad = result instanceof Number ? (char)'0' : ' ';
                    for (int i = r.length(); i < this.pattern.maxLength; ++i) {
                        s2.append(pad);
                    }
                }
                s2.append(r);
                if (this.pattern == PatternElement.Y_YYY && (this.padding || r.length() == 4)) {
                    s2.insert(s2.length() - 3, ',');
                }
                if (this.ordinal != null) {
                    String th = Formatter.getOrdinal(r);
                    s2.append(this.ordinal == Ordinal.TH ? th.toUpperCase() : th);
                }
            }

            public String toString() {
                return String.valueOf((Object)this.pattern) + (this.ordinal == null ? "" : this.ordinal.toString());
            }
        }

        static class Literal
        implements Part {
            final String contents;

            Literal(String contents) {
                this.contents = Formatter.unescape(contents);
            }

            @Override
            public void format(StringBuilder s2, Temporal input, Locale locale) {
                s2.append(this.contents);
            }

            public String toString() {
                return "\"" + this.contents + "\"";
            }
        }
    }

    private static class NumberFormat
    extends Formatter {
        private final Form form;
        private final Mask integerMask;
        private final Mask fractionMask;
        private final boolean padding;
        private final boolean currency;
        private final int shift;

        NumberFormat(String format) {
            NumericGroupProcessor p = new NumericGroupProcessor();
            Formatter.parse(NUMERIC_TEMPLATE, p, format);
            int split = p.decimalSeparator != -1 ? p.decimalSeparator : (p.afterLastDigit != -1 ? p.afterLastDigit : p.groups.size());
            boolean zero = p.integerDigits.indexOf("0") != -1 || p.fractionDigits.indexOf("0") != -1;
            this.integerMask = new Mask(true, p.groups.subList(0, split), p.integerDigits, !zero && p.integerDigits.length() > 0 ? 1 : 0);
            this.fractionMask = new Mask(false, p.groups.subList(split, p.groups.size()), p.fractionDigits, !zero && p.integerDigits.length() == 0 ? 1 : 0);
            this.form = p.roman && this.integerMask.digits == 0 && this.fractionMask.digits == 0 ? Form.Roman : (p.exponential ? Form.Exponential : Form.Normal);
            this.padding = !p.fillMode;
            this.currency = p.currency;
            this.shift = p.shift;
            this.integerMask.ensureSignProvision(this.fractionMask);
            this.fractionMask.ensureSignProvision(this.integerMask);
        }

        @Override
        public String format(@Nonnull Object input, @Nonnull Locale locale) {
            if (!(input instanceof Number)) {
                throw QueryException.dataException((String)"Input parameter is expected to be numeric");
            }
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            StringBuilder s2 = new StringBuilder();
            String value = input.toString();
            boolean negative = value.startsWith("-");
            if (value.equals("NaN") || value.endsWith("Infinity")) {
                this.integerMask.format(s2, negative, null, null, 0, true, symbols);
                this.fractionMask.format(s2, negative, null, null, 0, true, symbols);
            } else {
                int i;
                StringBuilder r;
                int fractionLength;
                int dot = value.indexOf(46);
                int exp = value.indexOf(69, dot + 2);
                int e = exp != -1 ? exp : value.length();
                String integer = value.substring(negative ? 1 : 0, dot != -1 ? dot : e);
                String fraction = dot == -1 ? "" : value.substring(dot + 1, e);
                int exponent = exp == -1 ? 0 : Integer.parseInt(value.substring(exp + 1));
                Object digits = integer + fraction;
                while (((String)digits).startsWith("0")) {
                    digits = ((String)digits).substring(1);
                }
                if (!((String)digits).isEmpty()) {
                    exponent -= fraction.length();
                }
                boolean exponential = this.form == Form.Exponential;
                int integerLength = exponential ? this.integerMask.digits : ((String)digits).length() + (exponent += this.shift);
                int n = fractionLength = exponential ? this.fractionMask.digits : -exponent;
                if (!((String)digits).isEmpty()) {
                    exponent += ((String)digits).length() - integerLength;
                }
                if ((exponential ? ((String)digits).length() > integerLength + this.fractionMask.digits : fractionLength > this.fractionMask.digits && integerLength + this.fractionMask.digits >= 0) && ((String)digits).charAt(integerLength + this.fractionMask.digits) >= '5') {
                    r = new StringBuilder((String)digits);
                    for (i = integerLength + this.fractionMask.digits - 1; i >= 0; --i) {
                        if (r.charAt(i) != '9') {
                            r.setCharAt(i, (char)(r.charAt(i) + '\u0001'));
                            break;
                        }
                        r.setCharAt(i, '0');
                    }
                    if (r.charAt(0) == '0') {
                        r.insert(0, '1');
                        if (!exponential) {
                            ++integerLength;
                        }
                    }
                    digits = r.toString();
                }
                if (integerLength > ((String)digits).length()) {
                    r = new StringBuilder(integerLength);
                    r.append((String)digits);
                    for (i = ((String)digits).length(); i < integerLength; ++i) {
                        r.append('0');
                    }
                    integer = r.toString();
                    fraction = "";
                } else if (integerLength < 0) {
                    r = new StringBuilder();
                    for (i = 0; i < Math.min(-integerLength, this.fractionMask.digits); ++i) {
                        r.append('0');
                    }
                    if (-integerLength < this.fractionMask.digits) {
                        r.append((CharSequence)digits, 0, integerLength + this.fractionMask.digits);
                    }
                    fraction = r.toString();
                    integer = "";
                    integerLength = 0;
                } else {
                    integer = ((String)digits).substring(0, integerLength);
                    fraction = ((String)digits).substring(integerLength, Math.min(integerLength + this.fractionMask.digits, ((String)digits).length()));
                }
                if (integer.isEmpty() && this.integerMask.minDigits > 0) {
                    integer = "0";
                }
                boolean overflow = this.form != Form.Roman && integerLength > this.integerMask.digits;
                this.integerMask.format(s2, negative, integer, fraction, exponent, overflow, symbols);
                this.fractionMask.format(s2, negative, integer, fraction, exponent, overflow, symbols);
            }
            return s2.toString();
        }

        public String toString() {
            return this.integerMask.toString() + this.fractionMask.toString();
        }

        static class NumericGroupProcessor
        implements GroupProcessor {
            final List<Object> groups = new ArrayList<Object>();
            final StringBuilder integerDigits = new StringBuilder();
            final StringBuilder fractionDigits = new StringBuilder();
            int decimalSeparator = -1;
            int afterLastDigit = -1;
            boolean fillMode;
            boolean currency;
            boolean exponential;
            boolean roman;
            int shift;

            NumericGroupProcessor() {
            }

            @Override
            public void acceptLiteral(String literal) {
                this.add(new Literal(literal));
            }

            @Override
            public void acceptGroup(String group, Matcher m4) {
                String g2 = group.toUpperCase();
                if (g2.equals("FM")) {
                    this.fillMode = true;
                } else if (g2.startsWith("V")) {
                    this.shift += group.length() - 1;
                } else if (g2.startsWith("F") || g2.startsWith("\"")) {
                    this.add(new Literal(group));
                } else if (g2.startsWith("9") || g2.startsWith("0")) {
                    (this.decimalSeparator == -1 ? this.integerDigits : this.fractionDigits).append(group);
                    this.add(group.length());
                    this.afterLastDigit = this.groups.size();
                } else if (g2.length() == 1 && ",G.D".contains(g2)) {
                    if (".D".contains(g2) && this.decimalSeparator == -1) {
                        this.decimalSeparator = this.groups.size();
                    }
                    this.add(Character.valueOf(g2.charAt(0)));
                } else {
                    PatternElement pattern = Formatter.valueOf(PatternElement.class, group);
                    this.add(pattern);
                    if (pattern == PatternElement.CR || pattern == PatternElement.C) {
                        this.currency = true;
                    } else if (pattern == PatternElement.EEEE || pattern == PatternElement.eeee) {
                        this.exponential = true;
                    } else if (pattern == PatternElement.RN || pattern == PatternElement.rn) {
                        this.roman = true;
                    }
                }
            }

            void add(Object group) {
                this.groups.add(group);
            }
        }

        class Mask {
            final boolean pre;
            final List<Object> groups;
            final int digits;
            final int minDigits;
            int offerSign = -1;
            boolean negative;
            PatternElement bracket;

            Mask(boolean pre, List<Object> groups, StringBuilder digitMask, int minDigits) {
                this.pre = pre;
                this.groups = new ArrayList<Object>(groups);
                if (pre) {
                    Collections.reverse(this.groups);
                    digitMask.reverse();
                }
                for (int i = 0; i < this.groups.size(); ++i) {
                    Object g2 = this.groups.get(i);
                    if (!(g2 instanceof Anchorable) || ((Anchorable)g2).isAnchored()) {
                        this.offerSign = i;
                    }
                    if (!(g2 instanceof PatternElement) || !((PatternElement)g2).isNegativeSign()) continue;
                    this.negative = true;
                    if (g2 != PatternElement.BR && g2 != PatternElement.B) continue;
                    this.bracket = (PatternElement)g2;
                }
                ++this.offerSign;
                this.digits = digitMask.length();
                this.minDigits = Math.max(digitMask.lastIndexOf("0") + 1, minDigits);
            }

            void ensureSignProvision(Mask pair) {
                PatternElement inferred;
                PatternElement patternElement = this.bracket == null && pair.bracket != null ? pair.bracket : (inferred = this.pre && !(this.negative | pair.negative) && this.digits + pair.digits > 0 && NumberFormat.this.form != Form.Roman ? PatternElement.M : null);
                if (inferred != null) {
                    this.groups.add(this.offerSign, inferred);
                }
            }

            void format(StringBuilder s2, boolean negative, String integer, String fraction, int exponent, boolean overflow, DecimalFormatSymbols symbols) {
                StringBuilder digits;
                StringBuilder stringBuilder = overflow ? null : (digits = this.pre ? new StringBuilder(integer).reverse() : new StringBuilder(fraction));
                if (!overflow) {
                    int length;
                    while (digits.length() < this.minDigits) {
                        digits.append('0');
                    }
                    for (length = digits.length(); length > this.minDigits && digits.charAt(length - 1) == '0'; --length) {
                    }
                    digits.setLength(length);
                }
                ArrayList<Object> parts = new ArrayList<Object>();
                int i = 0;
                int d = 0;
                int f = 0;
                while (i < this.groups.size()) {
                    StringBuilder r;
                    Object g2 = this.groups.get(i);
                    if (g2 instanceof Literal) {
                        parts.add(((Literal)g2).contents);
                    } else if (g2 instanceof PatternElement) {
                        PatternElement p = (PatternElement)g2;
                        if (p.isSign()) {
                            char c = p.getSign(this.pre, negative);
                            if (c != ' ') {
                                parts.add(Character.valueOf(c));
                            } else if (NumberFormat.this.padding) {
                                ++f;
                            }
                        } else if (p == PatternElement.CR || p == PatternElement.C) {
                            parts.add(symbols.getCurrencySymbol());
                        } else if (p == PatternElement.TH || p == PatternElement.th) {
                            if (integer != null && !integer.isEmpty()) {
                                String th = Formatter.getOrdinal(integer);
                                parts.add(p == PatternElement.TH ? th.toUpperCase() : th);
                            } else if (NumberFormat.this.padding) {
                                f += 2;
                            }
                        } else if (p == PatternElement.EEEE || p == PatternElement.eeee) {
                            StringBuilder r2 = new StringBuilder();
                            String e = symbols.getExponentSeparator();
                            r2.append(p == PatternElement.EEEE ? e : e.toLowerCase());
                            r2.append(exponent < 0 ? (char)'-' : '+');
                            if (overflow) {
                                r2.append("##");
                            } else {
                                ((exponent = Math.abs(exponent)) <= 9 ? r2.append('0') : r2).append(exponent);
                            }
                            parts.add(r2);
                        } else if (p == PatternElement.RN || p == PatternElement.rn) {
                            int n;
                            int n2 = integer == null || integer.length() > 4 ? Integer.MAX_VALUE : (n = integer.isEmpty() ? 0 : Integer.parseInt(integer));
                            if (NumberFormat.this.form == Form.Roman || n != 0) {
                                String r3 = Formatter.toRoman(NumberFormat.this.form == Form.Roman && (n == 0 || negative) ? Integer.MAX_VALUE : n);
                                parts.add(p == PatternElement.rn ? r3.toLowerCase() : r3);
                                if (NumberFormat.this.padding) {
                                    f += 15 - r3.length();
                                }
                            } else if (NumberFormat.this.padding) {
                                f += 15;
                            }
                        }
                    } else if (g2 instanceof Character) {
                        if (overflow || d < digits.length()) {
                            parts.add(g2.equals(Character.valueOf('G')) ? Character.valueOf(symbols.getGroupingSeparator()) : (g2.equals(Character.valueOf('D')) ? Character.valueOf(NumberFormat.this.currency ? symbols.getMonetaryDecimalSeparator() : symbols.getDecimalSeparator()) : g2));
                        } else if (NumberFormat.this.padding) {
                            ++f;
                        }
                    } else if (g2 instanceof Integer) {
                        if (overflow) {
                            r = new StringBuilder();
                            for (int j = 0; j < (Integer)g2; ++j) {
                                r.append('#');
                            }
                            parts.add(r);
                        } else if (d < digits.length()) {
                            int e = Math.min(d + (Integer)g2, digits.length());
                            StringBuilder r4 = new StringBuilder().append(digits, d, e);
                            parts.add(this.pre ? r4.reverse() : r4);
                            if (NumberFormat.this.padding) {
                                f += d + (Integer)g2 - e;
                            }
                        } else if (NumberFormat.this.padding) {
                            f += ((Integer)g2).intValue();
                        }
                        d += ((Integer)g2).intValue();
                    }
                    if (f <= 0 || ++i != this.groups.size() && (!(this.groups.get(i) instanceof Anchorable) || ((Anchorable)this.groups.get(i)).isAnchored())) continue;
                    r = new StringBuilder();
                    while (f > 0) {
                        r.append(' ');
                        --f;
                    }
                    parts.add(r);
                }
                if (this.pre) {
                    Collections.reverse(parts);
                }
                parts.forEach(s2::append);
            }

            public String toString() {
                ArrayList<Object> mask = new ArrayList<Object>(this.groups);
                if (this.pre) {
                    Collections.reverse(mask);
                }
                return ((Object)mask).toString();
            }
        }

        static enum Form {
            Normal,
            Exponential,
            Roman;

        }

        static class Literal
        implements Anchorable {
            final String contents;
            final boolean anchored;

            Literal(String literal) {
                this.anchored = "Ff".indexOf(literal.charAt(0)) == -1;
                this.contents = Formatter.unescape(literal.substring(this.anchored ? 0 : 1));
            }

            @Override
            public boolean isAnchored() {
                return this.anchored;
            }

            public String toString() {
                return (this.anchored ? "" : "F") + "\"" + this.contents + "\"";
            }
        }

        static enum PatternElement implements Anchorable
        {
            BR,
            B,
            SG,
            S,
            MI,
            M,
            PL,
            P,
            CR,
            C,
            TH,
            th,
            EEEE,
            eeee,
            RN,
            rn;

            static final List<PatternElement> SIGN;
            static final List<PatternElement> NEGATIVE;
            static final List<PatternElement> ANCHORED;

            boolean isSign() {
                return SIGN.contains(this);
            }

            boolean isNegativeSign() {
                return NEGATIVE.contains(this);
            }

            char getSign(boolean pre, boolean negative) {
                if (this == BR || this == B) {
                    return (char)(negative ? (pre ? 60 : 62) : 32);
                }
                if (this == SG || this == S) {
                    return negative ? (char)'-' : '+';
                }
                if (this == MI || this == M) {
                    return negative ? (char)'-' : ' ';
                }
                if (this == PL || this == P) {
                    return negative ? (char)' ' : '+';
                }
                throw new IllegalArgumentException();
            }

            @Override
            public boolean isAnchored() {
                return ANCHORED.contains(this);
            }

            static {
                SIGN = Arrays.asList(BR, B, SG, S, MI, M, PL, P);
                NEGATIVE = Arrays.asList(BR, B, SG, S, MI, M);
                ANCHORED = Arrays.asList(B, S, M, P, C, TH, th, EEEE, eeee, RN, rn);
            }
        }

        static interface Anchorable {
            public boolean isAnchored();
        }
    }

    static interface GroupProcessor {
        public void acceptLiteral(String var1);

        public void acceptGroup(String var1, Matcher var2);
    }
}

