/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.triangulate.polygon;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.noding.BasicSegmentString;
import com.hazelcast.shaded.org.locationtech.jts.noding.MCIndexSegmentSetMutualIntersector;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentIntersectionDetector;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentSetMutualIntersector;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class PolygonHoleJoiner {
    private static final double EPS = 1.0E-4;
    private List<Coordinate> shellCoords;
    private TreeSet<Coordinate> shellCoordsSorted;
    private HashMap<Coordinate, ArrayList<Coordinate>> cutMap;
    private SegmentSetMutualIntersector polygonIntersector;
    private Polygon inputPolygon;

    public static Polygon joinAsPolygon(Polygon inputPolygon) {
        return inputPolygon.getFactory().createPolygon(PolygonHoleJoiner.join(inputPolygon));
    }

    public static Coordinate[] join(Polygon inputPolygon) {
        PolygonHoleJoiner joiner = new PolygonHoleJoiner(inputPolygon);
        return joiner.compute();
    }

    public PolygonHoleJoiner(Polygon inputPolygon) {
        this.inputPolygon = inputPolygon;
        this.polygonIntersector = PolygonHoleJoiner.createPolygonIntersector(inputPolygon);
    }

    public Coordinate[] compute() {
        this.shellCoords = PolygonHoleJoiner.ringCoordinates(this.inputPolygon.getExteriorRing());
        if (this.inputPolygon.getNumInteriorRing() != 0) {
            this.joinHoles();
        }
        return this.shellCoords.toArray(new Coordinate[0]);
    }

    private static List<Coordinate> ringCoordinates(LinearRing ring) {
        Coordinate[] coords = ring.getCoordinates();
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        for (Coordinate p : coords) {
            coordList.add(p);
        }
        return coordList;
    }

    private void joinHoles() {
        this.shellCoordsSorted = new TreeSet();
        this.shellCoordsSorted.addAll(this.shellCoords);
        this.cutMap = new HashMap();
        List<LinearRing> orderedHoles = PolygonHoleJoiner.sortHoles(this.inputPolygon);
        for (int i = 0; i < orderedHoles.size(); ++i) {
            this.joinHole(orderedHoles.get(i));
        }
    }

    private void joinHole(LinearRing hole) {
        Coordinate[] holeCoords = hole.getCoordinates();
        List<Integer> holeLeftVerticesIndex = PolygonHoleJoiner.findLeftVertices(hole);
        Coordinate holeCoord = holeCoords[holeLeftVerticesIndex.get(0)];
        List<Coordinate> shellCoordsList = this.findLeftShellVertices(holeCoord);
        Coordinate shellCoord = shellCoordsList.get(0);
        int shortestHoleVertexIndex = 0;
        if (Math.abs(shellCoord.x - holeCoord.x) < 1.0E-4) {
            double shortest = Double.MAX_VALUE;
            for (int i = 0; i < holeLeftVerticesIndex.size(); ++i) {
                for (int j = 0; j < shellCoordsList.size(); ++j) {
                    double currLength = Math.abs(shellCoordsList.get((int)j).y - holeCoords[holeLeftVerticesIndex.get((int)i).intValue()].y);
                    if (!(currLength < shortest)) continue;
                    shortest = currLength;
                    shortestHoleVertexIndex = i;
                    shellCoord = shellCoordsList.get(j);
                }
            }
        }
        int shellVertexIndex = this.getShellCoordIndex(shellCoord, holeCoords[holeLeftVerticesIndex.get(shortestHoleVertexIndex)]);
        this.addHoleToShell(shellVertexIndex, holeCoords, holeLeftVerticesIndex.get(shortestHoleVertexIndex));
    }

    private int getShellCoordIndex(Coordinate shellVertex, Coordinate holeVertex) {
        int numSkip = 0;
        ArrayList<Coordinate> newValueList = new ArrayList<Coordinate>();
        newValueList.add(holeVertex);
        if (this.cutMap.containsKey(shellVertex)) {
            for (Coordinate coord : this.cutMap.get(shellVertex)) {
                if (!(coord.y < holeVertex.y)) continue;
                ++numSkip;
            }
            this.cutMap.get(shellVertex).add(holeVertex);
        } else {
            this.cutMap.put(shellVertex, newValueList);
        }
        if (!this.cutMap.containsKey(holeVertex)) {
            this.cutMap.put(holeVertex, new ArrayList(newValueList));
        }
        return this.getShellCoordIndexSkip(shellVertex, numSkip);
    }

    private int getShellCoordIndexSkip(Coordinate coord, int numSkip) {
        for (int i = 0; i < this.shellCoords.size(); ++i) {
            if (!this.shellCoords.get(i).equals2D(coord, 1.0E-4)) continue;
            if (numSkip == 0) {
                return i;
            }
            --numSkip;
        }
        throw new IllegalStateException("Vertex is not in shellcoords");
    }

    private List<Coordinate> findLeftShellVertices(Coordinate holeCoord) {
        ArrayList<Coordinate> list = new ArrayList<Coordinate>();
        Coordinate closest = this.shellCoordsSorted.higher(holeCoord);
        while (closest.x == holeCoord.x) {
            closest = this.shellCoordsSorted.higher(closest);
        }
        while (!this.isJoinable(holeCoord, closest = this.shellCoordsSorted.lower(closest)) && !closest.equals(this.shellCoordsSorted.first())) {
        }
        list.add(closest);
        if (closest.x != holeCoord.x) {
            return list;
        }
        double chosenX = closest.x;
        list.clear();
        while (chosenX == closest.x) {
            list.add(closest);
            if ((closest = this.shellCoordsSorted.lower(closest)) != null) continue;
            return list;
        }
        return list;
    }

    private boolean isJoinable(Coordinate holeCoord, Coordinate shellCoord) {
        boolean isJoinable = !this.crossesPolygon(holeCoord, shellCoord);
        return isJoinable;
    }

    private boolean crossesPolygon(Coordinate p0, Coordinate p1) {
        BasicSegmentString segString = new BasicSegmentString(new Coordinate[]{p0, p1}, null);
        ArrayList<BasicSegmentString> segStrings = new ArrayList<BasicSegmentString>();
        segStrings.add(segString);
        SegmentIntersectionDetector segInt = new SegmentIntersectionDetector();
        segInt.setFindProper(true);
        this.polygonIntersector.process(segStrings, segInt);
        return segInt.hasProperIntersection();
    }

    private void addHoleToShell(int shellJoinIndex, Coordinate[] holeCoords, int holeJoinIndex) {
        Coordinate shellJoinPt = this.shellCoords.get(shellJoinIndex);
        Coordinate holeJoinPt = holeCoords[holeJoinIndex];
        boolean isJoinTouching = shellJoinPt.equals2D(holeJoinPt);
        ArrayList<Coordinate> newSection = new ArrayList<Coordinate>();
        if (!isJoinTouching) {
            newSection.add(new Coordinate(shellJoinPt));
        }
        int nPts = holeCoords.length - 1;
        int i = holeJoinIndex;
        do {
            newSection.add(new Coordinate(holeCoords[i]));
        } while ((i = (i + 1) % nPts) != holeJoinIndex);
        if (!isJoinTouching) {
            newSection.add(new Coordinate(holeCoords[holeJoinIndex]));
        }
        this.shellCoords.addAll(shellJoinIndex, newSection);
        this.shellCoordsSorted.addAll(newSection);
    }

    private static List<LinearRing> sortHoles(Polygon poly) {
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            holes.add(poly.getInteriorRingN(i));
        }
        Collections.sort(holes, new EnvelopeComparator());
        return holes;
    }

    private static List<Integer> findLeftVertices(LinearRing ring) {
        Coordinate[] coords = ring.getCoordinates();
        ArrayList<Integer> leftmostIndex = new ArrayList<Integer>();
        double leftX = ring.getEnvelopeInternal().getMinX();
        for (int i = 0; i < coords.length - 1; ++i) {
            if (!(Math.abs(coords[i].x - leftX) < 1.0E-4)) continue;
            leftmostIndex.add(i);
        }
        return leftmostIndex;
    }

    private static SegmentSetMutualIntersector createPolygonIntersector(Polygon polygon) {
        List polySegStrings = SegmentStringUtil.extractSegmentStrings(polygon);
        return new MCIndexSegmentSetMutualIntersector(polySegStrings);
    }

    private static class EnvelopeComparator
    implements Comparator<Geometry> {
        private EnvelopeComparator() {
        }

        @Override
        public int compare(Geometry o1, Geometry o2) {
            Envelope e1 = o1.getEnvelopeInternal();
            Envelope e2 = o2.getEnvelopeInternal();
            return e1.compareTo(e2);
        }
    }
}

