/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.simplify;

import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineSegment;
import com.hazelcast.shaded.org.locationtech.jts.index.quadtree.Quadtree;
import com.hazelcast.shaded.org.locationtech.jts.simplify.LineSegmentVisitor;
import com.hazelcast.shaded.org.locationtech.jts.simplify.TaggedLineSegment;
import com.hazelcast.shaded.org.locationtech.jts.simplify.TaggedLineString;
import java.util.ArrayList;
import java.util.List;

class LineSegmentIndex {
    private Quadtree index = new Quadtree();

    public void add(TaggedLineString line) {
        TaggedLineSegment[] segs = line.getSegments();
        for (int i = 0; i < segs.length; ++i) {
            TaggedLineSegment seg = segs[i];
            this.add(seg);
        }
    }

    public void add(LineSegment seg) {
        this.index.insert(new Envelope(seg.p0, seg.p1), seg);
    }

    public void remove(LineSegment seg) {
        this.index.remove(new Envelope(seg.p0, seg.p1), seg);
    }

    public List query(LineSegment querySeg) {
        Envelope env = new Envelope(querySeg.p0, querySeg.p1);
        LineSegmentVisitor visitor = new LineSegmentVisitor(querySeg);
        this.index.query(env, visitor);
        ArrayList itemsFound = visitor.getItems();
        return itemsFound;
    }
}

