/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.precision;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateList;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.GeometryEditor;

public class PrecisionReducerCoordinateOperation
extends GeometryEditor.CoordinateOperation {
    private PrecisionModel targetPM;
    private boolean removeCollapsed = true;

    public PrecisionReducerCoordinateOperation(PrecisionModel targetPM, boolean removeCollapsed) {
        this.targetPM = targetPM;
        this.removeCollapsed = removeCollapsed;
    }

    @Override
    public Coordinate[] edit(Coordinate[] coordinates, Geometry geom) {
        if (coordinates.length == 0) {
            return null;
        }
        Coordinate[] reducedCoords = new Coordinate[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate coord = new Coordinate(coordinates[i]);
            this.targetPM.makePrecise(coord);
            reducedCoords[i] = coord;
        }
        CoordinateList noRepeatedCoordList = new CoordinateList(reducedCoords, false);
        Coordinate[] noRepeatedCoords = noRepeatedCoordList.toCoordinateArray();
        int minLength = 0;
        if (geom instanceof LineString) {
            minLength = 2;
        }
        if (geom instanceof LinearRing) {
            minLength = 4;
        }
        Coordinate[] collapsedCoords = reducedCoords;
        if (this.removeCollapsed) {
            collapsedCoords = null;
        }
        if (noRepeatedCoords.length < minLength) {
            return collapsedCoords;
        }
        return noRepeatedCoords;
    }
}

