/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.predicate;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.RectangleLineIntersector;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.LinearComponentExtracter;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.ShortCircuitedGeometryVisitor;
import java.util.List;

class RectangleIntersectsSegmentVisitor
extends ShortCircuitedGeometryVisitor {
    private Envelope rectEnv;
    private RectangleLineIntersector rectIntersector;
    private boolean hasIntersection = false;

    public RectangleIntersectsSegmentVisitor(Polygon rectangle) {
        this.rectEnv = rectangle.getEnvelopeInternal();
        this.rectIntersector = new RectangleLineIntersector(this.rectEnv);
    }

    public boolean intersects() {
        return this.hasIntersection;
    }

    @Override
    protected void visit(Geometry geom) {
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        List lines = LinearComponentExtracter.getLines(geom);
        this.checkIntersectionWithLineStrings(lines);
    }

    private void checkIntersectionWithLineStrings(List lines) {
        for (LineString testLine : lines) {
            this.checkIntersectionWithSegments(testLine);
            if (!this.hasIntersection) continue;
            return;
        }
    }

    private void checkIntersectionWithSegments(LineString testLine) {
        CoordinateSequence seq1 = testLine.getCoordinateSequence();
        Coordinate p0 = seq1.createCoordinate();
        Coordinate p1 = seq1.createCoordinate();
        for (int j = 1; j < seq1.size(); ++j) {
            seq1.getCoordinate(j - 1, p0);
            seq1.getCoordinate(j, p1);
            if (!this.rectIntersector.intersects(p0, p1)) continue;
            this.hasIntersection = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.hasIntersection;
    }
}

