/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.TopologyException;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.MaximalEdgeRing;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayEdge;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayEdgeRing;
import com.hazelcast.shaded.org.locationtech.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class PolygonBuilder {
    private GeometryFactory geometryFactory;
    private List<OverlayEdgeRing> shellList = new ArrayList<OverlayEdgeRing>();
    private List<OverlayEdgeRing> freeHoleList = new ArrayList<OverlayEdgeRing>();
    private boolean isEnforcePolygonal = true;

    public PolygonBuilder(List<OverlayEdge> resultAreaEdges, GeometryFactory geomFact) {
        this(resultAreaEdges, geomFact, true);
    }

    public PolygonBuilder(List<OverlayEdge> resultAreaEdges, GeometryFactory geomFact, boolean isEnforcePolygonal) {
        this.geometryFactory = geomFact;
        this.isEnforcePolygonal = isEnforcePolygonal;
        this.buildRings(resultAreaEdges);
    }

    public List<Polygon> getPolygons() {
        return this.computePolygons(this.shellList);
    }

    public List<OverlayEdgeRing> getShellRings() {
        return this.shellList;
    }

    private List<Polygon> computePolygons(List<OverlayEdgeRing> shellList) {
        ArrayList<Polygon> resultPolyList = new ArrayList<Polygon>();
        for (OverlayEdgeRing er : shellList) {
            Polygon poly = er.toPolygon(this.geometryFactory);
            resultPolyList.add(poly);
        }
        return resultPolyList;
    }

    private void buildRings(List<OverlayEdge> resultAreaEdges) {
        this.linkResultAreaEdgesMax(resultAreaEdges);
        List<MaximalEdgeRing> maxRings = PolygonBuilder.buildMaximalRings(resultAreaEdges);
        this.buildMinimalRings(maxRings);
        this.placeFreeHoles(this.shellList, this.freeHoleList);
    }

    private void linkResultAreaEdgesMax(List<OverlayEdge> resultEdges) {
        for (OverlayEdge edge : resultEdges) {
            MaximalEdgeRing.linkResultAreaMaxRingAtNode(edge);
        }
    }

    private static List<MaximalEdgeRing> buildMaximalRings(Collection<OverlayEdge> edges) {
        ArrayList<MaximalEdgeRing> edgeRings = new ArrayList<MaximalEdgeRing>();
        for (OverlayEdge e : edges) {
            if (!e.isInResultArea() || !e.getLabel().isBoundaryEither() || e.getEdgeRingMax() != null) continue;
            MaximalEdgeRing er = new MaximalEdgeRing(e);
            edgeRings.add(er);
        }
        return edgeRings;
    }

    private void buildMinimalRings(List<MaximalEdgeRing> maxRings) {
        for (MaximalEdgeRing erMax : maxRings) {
            List<OverlayEdgeRing> minRings = erMax.buildMinimalRings(this.geometryFactory);
            this.assignShellsAndHoles(minRings);
        }
    }

    private void assignShellsAndHoles(List<OverlayEdgeRing> minRings) {
        OverlayEdgeRing shell = this.findSingleShell(minRings);
        if (shell != null) {
            PolygonBuilder.assignHoles(shell, minRings);
            this.shellList.add(shell);
        } else {
            this.freeHoleList.addAll(minRings);
        }
    }

    private OverlayEdgeRing findSingleShell(List<OverlayEdgeRing> edgeRings) {
        int shellCount = 0;
        OverlayEdgeRing shell = null;
        for (OverlayEdgeRing er : edgeRings) {
            if (er.isHole()) continue;
            shell = er;
            ++shellCount;
        }
        Assert.isTrue(shellCount <= 1, "found two shells in EdgeRing list");
        return shell;
    }

    private static void assignHoles(OverlayEdgeRing shell, List<OverlayEdgeRing> edgeRings) {
        for (OverlayEdgeRing er : edgeRings) {
            if (!er.isHole()) continue;
            er.setShell(shell);
        }
    }

    private void placeFreeHoles(List<OverlayEdgeRing> shellList, List<OverlayEdgeRing> freeHoleList) {
        for (OverlayEdgeRing hole : freeHoleList) {
            if (hole.getShell() != null) continue;
            OverlayEdgeRing shell = hole.findEdgeRingContaining(shellList);
            if (this.isEnforcePolygonal && shell == null) {
                throw new TopologyException("unable to assign free hole to a shell", hole.getCoordinate());
            }
            hole.setShell(shell);
        }
    }
}

