/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Location;

class OverlayLabel {
    private static final char SYM_UNKNOWN = '#';
    private static final char SYM_BOUNDARY = 'B';
    private static final char SYM_COLLAPSE = 'C';
    private static final char SYM_LINE = 'L';
    public static final int DIM_UNKNOWN = -1;
    public static final int DIM_NOT_PART = -1;
    public static final int DIM_LINE = 1;
    public static final int DIM_BOUNDARY = 2;
    public static final int DIM_COLLAPSE = 3;
    public static int LOC_UNKNOWN = -1;
    private int aDim = -1;
    private boolean aIsHole = false;
    private int aLocLeft = LOC_UNKNOWN;
    private int aLocRight = LOC_UNKNOWN;
    private int aLocLine = LOC_UNKNOWN;
    private int bDim = -1;
    private boolean bIsHole = false;
    private int bLocLeft = LOC_UNKNOWN;
    private int bLocRight = LOC_UNKNOWN;
    private int bLocLine = LOC_UNKNOWN;

    public OverlayLabel(int index, int locLeft, int locRight, boolean isHole) {
        this.initBoundary(index, locLeft, locRight, isHole);
    }

    public OverlayLabel(int index) {
        this.initLine(index);
    }

    public OverlayLabel() {
    }

    public OverlayLabel(OverlayLabel lbl) {
        this.aLocLeft = lbl.aLocLeft;
        this.aLocRight = lbl.aLocRight;
        this.aLocLine = lbl.aLocLine;
        this.aDim = lbl.aDim;
        this.aIsHole = lbl.aIsHole;
        this.bLocLeft = lbl.bLocLeft;
        this.bLocRight = lbl.bLocRight;
        this.bLocLine = lbl.bLocLine;
        this.bDim = lbl.bDim;
        this.bIsHole = lbl.bIsHole;
    }

    public int dimension(int index) {
        if (index == 0) {
            return this.aDim;
        }
        return this.bDim;
    }

    public void initBoundary(int index, int locLeft, int locRight, boolean isHole) {
        if (index == 0) {
            this.aDim = 2;
            this.aIsHole = isHole;
            this.aLocLeft = locLeft;
            this.aLocRight = locRight;
            this.aLocLine = 0;
        } else {
            this.bDim = 2;
            this.bIsHole = isHole;
            this.bLocLeft = locLeft;
            this.bLocRight = locRight;
            this.bLocLine = 0;
        }
    }

    public void initCollapse(int index, boolean isHole) {
        if (index == 0) {
            this.aDim = 3;
            this.aIsHole = isHole;
        } else {
            this.bDim = 3;
            this.bIsHole = isHole;
        }
    }

    public void initLine(int index) {
        if (index == 0) {
            this.aDim = 1;
            this.aLocLine = LOC_UNKNOWN;
        } else {
            this.bDim = 1;
            this.bLocLine = LOC_UNKNOWN;
        }
    }

    public void initNotPart(int index) {
        if (index == 0) {
            this.aDim = -1;
        } else {
            this.bDim = -1;
        }
    }

    public void setLocationLine(int index, int loc) {
        if (index == 0) {
            this.aLocLine = loc;
        } else {
            this.bLocLine = loc;
        }
    }

    public void setLocationAll(int index, int loc) {
        if (index == 0) {
            this.aLocLine = loc;
            this.aLocLeft = loc;
            this.aLocRight = loc;
        } else {
            this.bLocLine = loc;
            this.bLocLeft = loc;
            this.bLocRight = loc;
        }
    }

    public void setLocationCollapse(int index) {
        int loc;
        int n = loc = this.isHole(index) ? 0 : 2;
        if (index == 0) {
            this.aLocLine = loc;
        } else {
            this.bLocLine = loc;
        }
    }

    public boolean isLine() {
        return this.aDim == 1 || this.bDim == 1;
    }

    public boolean isLine(int index) {
        if (index == 0) {
            return this.aDim == 1;
        }
        return this.bDim == 1;
    }

    public boolean isLinear(int index) {
        if (index == 0) {
            return this.aDim == 1 || this.aDim == 3;
        }
        return this.bDim == 1 || this.bDim == 3;
    }

    public boolean isKnown(int index) {
        if (index == 0) {
            return this.aDim != -1;
        }
        return this.bDim != -1;
    }

    public boolean isNotPart(int index) {
        if (index == 0) {
            return this.aDim == -1;
        }
        return this.bDim == -1;
    }

    public boolean isBoundaryEither() {
        return this.aDim == 2 || this.bDim == 2;
    }

    public boolean isBoundaryBoth() {
        return this.aDim == 2 && this.bDim == 2;
    }

    public boolean isBoundaryCollapse() {
        if (this.isLine()) {
            return false;
        }
        return !this.isBoundaryBoth();
    }

    public boolean isBoundaryTouch() {
        return this.isBoundaryBoth() && this.getLocation(0, 2, true) != this.getLocation(1, 2, true);
    }

    public boolean isBoundary(int index) {
        if (index == 0) {
            return this.aDim == 2;
        }
        return this.bDim == 2;
    }

    public boolean isBoundarySingleton() {
        if (this.aDim == 2 && this.bDim == -1) {
            return true;
        }
        return this.bDim == 2 && this.aDim == -1;
    }

    public boolean isLineLocationUnknown(int index) {
        if (index == 0) {
            return this.aLocLine == LOC_UNKNOWN;
        }
        return this.bLocLine == LOC_UNKNOWN;
    }

    public boolean isLineInArea(int index) {
        if (index == 0) {
            return this.aLocLine == 0;
        }
        return this.bLocLine == 0;
    }

    public boolean isHole(int index) {
        if (index == 0) {
            return this.aIsHole;
        }
        return this.bIsHole;
    }

    public boolean isCollapse(int index) {
        return this.dimension(index) == 3;
    }

    public boolean isInteriorCollapse() {
        if (this.aDim == 3 && this.aLocLine == 0) {
            return true;
        }
        return this.bDim == 3 && this.bLocLine == 0;
    }

    public boolean isCollapseAndNotPartInterior() {
        if (this.aDim == 3 && this.bDim == -1 && this.bLocLine == 0) {
            return true;
        }
        return this.bDim == 3 && this.aDim == -1 && this.aLocLine == 0;
    }

    public int getLineLocation(int index) {
        if (index == 0) {
            return this.aLocLine;
        }
        return this.bLocLine;
    }

    public boolean isLineInterior(int index) {
        if (index == 0) {
            return this.aLocLine == 0;
        }
        return this.bLocLine == 0;
    }

    public int getLocation(int index, int position, boolean isForward) {
        if (index == 0) {
            switch (position) {
                case 1: {
                    return isForward ? this.aLocLeft : this.aLocRight;
                }
                case 2: {
                    return isForward ? this.aLocRight : this.aLocLeft;
                }
                case 0: {
                    return this.aLocLine;
                }
            }
        }
        switch (position) {
            case 1: {
                return isForward ? this.bLocLeft : this.bLocRight;
            }
            case 2: {
                return isForward ? this.bLocRight : this.bLocLeft;
            }
            case 0: {
                return this.bLocLine;
            }
        }
        return LOC_UNKNOWN;
    }

    public int getLocationBoundaryOrLine(int index, int position, boolean isForward) {
        if (this.isBoundary(index)) {
            return this.getLocation(index, position, isForward);
        }
        return this.getLineLocation(index);
    }

    public int getLocation(int index) {
        if (index == 0) {
            return this.aLocLine;
        }
        return this.bLocLine;
    }

    public boolean hasSides(int index) {
        if (index == 0) {
            return this.aLocLeft != LOC_UNKNOWN || this.aLocRight != LOC_UNKNOWN;
        }
        return this.bLocLeft != LOC_UNKNOWN || this.bLocRight != LOC_UNKNOWN;
    }

    public OverlayLabel copy() {
        return new OverlayLabel(this);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean isForward) {
        StringBuilder buf = new StringBuilder();
        buf.append("A:");
        buf.append(this.locationString(0, isForward));
        buf.append("/B:");
        buf.append(this.locationString(1, isForward));
        return buf.toString();
    }

    private String locationString(int index, boolean isForward) {
        StringBuilder buf = new StringBuilder();
        if (this.isBoundary(index)) {
            buf.append(Location.toLocationSymbol(this.getLocation(index, 1, isForward)));
            buf.append(Location.toLocationSymbol(this.getLocation(index, 2, isForward)));
        } else {
            buf.append(Location.toLocationSymbol(index == 0 ? this.aLocLine : this.bLocLine));
        }
        if (this.isKnown(index)) {
            buf.append(OverlayLabel.dimensionSymbol(index == 0 ? this.aDim : this.bDim));
        }
        if (this.isCollapse(index)) {
            buf.append(OverlayLabel.ringRoleSymbol(index == 0 ? this.aIsHole : this.bIsHole));
        }
        return buf.toString();
    }

    public static char ringRoleSymbol(boolean isHole) {
        return isHole ? (char)'h' : 's';
    }

    public static char dimensionSymbol(int dim) {
        switch (dim) {
            case 1: {
                return 'L';
            }
            case 3: {
                return 'C';
            }
            case 2: {
                return 'B';
            }
        }
        return '#';
    }
}

