/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.distance;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.ItemBoundable;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.ItemDistance;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.STRtree;
import com.hazelcast.shaded.org.locationtech.jts.operation.distance.FacetSequence;
import com.hazelcast.shaded.org.locationtech.jts.operation.distance.FacetSequenceTreeBuilder;
import com.hazelcast.shaded.org.locationtech.jts.operation.distance.GeometryLocation;

public class IndexedFacetDistance {
    private static final FacetSequenceDistance FACET_SEQ_DIST = new FacetSequenceDistance();
    private STRtree cachedTree;
    private Geometry baseGeometry;

    public static double distance(Geometry g1, Geometry g2) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.distance(g2);
    }

    public static boolean isWithinDistance(Geometry g1, Geometry g2, double distance) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.isWithinDistance(g2, distance);
    }

    public static Coordinate[] nearestPoints(Geometry g1, Geometry g2) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.nearestPoints(g2);
    }

    public IndexedFacetDistance(Geometry geom) {
        this.baseGeometry = geom;
        this.cachedTree = FacetSequenceTreeBuilder.build(geom);
    }

    public double distance(Geometry g2) {
        STRtree tree2 = FacetSequenceTreeBuilder.build(g2);
        Object[] obj = this.cachedTree.nearestNeighbour(tree2, FACET_SEQ_DIST);
        FacetSequence fs1 = (FacetSequence)obj[0];
        FacetSequence fs2 = (FacetSequence)obj[1];
        return fs1.distance(fs2);
    }

    public GeometryLocation[] nearestLocations(Geometry g2) {
        STRtree tree2 = FacetSequenceTreeBuilder.build(g2);
        Object[] obj = this.cachedTree.nearestNeighbour(tree2, FACET_SEQ_DIST);
        FacetSequence fs1 = (FacetSequence)obj[0];
        FacetSequence fs2 = (FacetSequence)obj[1];
        return fs1.nearestLocations(fs2);
    }

    public Coordinate[] nearestPoints(Geometry g2) {
        GeometryLocation[] minDistanceLocation = this.nearestLocations(g2);
        Coordinate[] nearestPts = IndexedFacetDistance.toPoints(minDistanceLocation);
        return nearestPts;
    }

    private static Coordinate[] toPoints(GeometryLocation[] locations) {
        if (locations == null) {
            return null;
        }
        Coordinate[] nearestPts = new Coordinate[]{locations[0].getCoordinate(), locations[1].getCoordinate()};
        return nearestPts;
    }

    public boolean isWithinDistance(Geometry g2, double maxDistance) {
        double envDist = this.baseGeometry.getEnvelopeInternal().distance(g2.getEnvelopeInternal());
        if (envDist > maxDistance) {
            return false;
        }
        STRtree tree2 = FacetSequenceTreeBuilder.build(g2);
        return this.cachedTree.isWithinDistance(tree2, FACET_SEQ_DIST, maxDistance);
    }

    private static class FacetSequenceDistance
    implements ItemDistance {
        private FacetSequenceDistance() {
        }

        @Override
        public double distance(ItemBoundable item1, ItemBoundable item2) {
            FacetSequence fs1 = (FacetSequence)item1.getItem();
            FacetSequence fs2 = (FacetSequence)item2.getItem();
            return fs1.distance(fs2);
        }
    }
}

