/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.noding;

import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateArrays;
import com.hazelcast.shaded.org.locationtech.jts.noding.OrientedCoordinateArray;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentString;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SegmentStringDissolver {
    private SegmentStringMerger merger;
    private Map ocaMap = new TreeMap();

    public SegmentStringDissolver(SegmentStringMerger merger) {
        this.merger = merger;
    }

    public SegmentStringDissolver() {
        this(null);
    }

    public void dissolve(Collection segStrings) {
        Iterator i = segStrings.iterator();
        while (i.hasNext()) {
            this.dissolve((SegmentString)i.next());
        }
    }

    private void add(OrientedCoordinateArray oca, SegmentString segString) {
        this.ocaMap.put(oca, segString);
    }

    public void dissolve(SegmentString segString) {
        OrientedCoordinateArray oca = new OrientedCoordinateArray(segString.getCoordinates());
        SegmentString existing = this.findMatching(oca, segString);
        if (existing == null) {
            this.add(oca, segString);
        } else if (this.merger != null) {
            boolean isSameOrientation = CoordinateArrays.equals(existing.getCoordinates(), segString.getCoordinates());
            this.merger.merge(existing, segString, isSameOrientation);
        }
    }

    private SegmentString findMatching(OrientedCoordinateArray oca, SegmentString segString) {
        SegmentString matchSS = (SegmentString)this.ocaMap.get(oca);
        return matchSS;
    }

    public Collection getDissolved() {
        return this.ocaMap.values();
    }

    public static interface SegmentStringMerger {
        public void merge(SegmentString var1, SegmentString var2, boolean var3);
    }
}

