/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.index.intervalrtree;

import com.hazelcast.shaded.org.locationtech.jts.index.ItemVisitor;
import com.hazelcast.shaded.org.locationtech.jts.index.intervalrtree.IntervalRTreeNode;

public class IntervalRTreeBranchNode
extends IntervalRTreeNode {
    private IntervalRTreeNode node1;
    private IntervalRTreeNode node2;

    public IntervalRTreeBranchNode(IntervalRTreeNode n1, IntervalRTreeNode n2) {
        this.node1 = n1;
        this.node2 = n2;
        this.buildExtent(this.node1, this.node2);
    }

    private void buildExtent(IntervalRTreeNode n1, IntervalRTreeNode n2) {
        this.min = Math.min(n1.min, n2.min);
        this.max = Math.max(n1.max, n2.max);
    }

    @Override
    public void query(double queryMin, double queryMax, ItemVisitor visitor) {
        if (!this.intersects(queryMin, queryMax)) {
            return;
        }
        if (this.node1 != null) {
            this.node1.query(queryMin, queryMax, visitor);
        }
        if (this.node2 != null) {
            this.node2.query(queryMin, queryMax, visitor);
        }
    }
}

