/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom.prep;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.prep.PreparedPolygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.ComponentCoordinateExtracter;
import java.util.List;

abstract class PreparedPolygonPredicate {
    protected PreparedPolygon prepPoly;
    private PointOnGeometryLocator targetPointLocator;

    public PreparedPolygonPredicate(PreparedPolygon prepPoly) {
        this.prepPoly = prepPoly;
        this.targetPointLocator = prepPoly.getPointLocator();
    }

    protected boolean isAllTestComponentsInTarget(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        for (Coordinate p : coords) {
            int loc = this.targetPointLocator.locate(p);
            if (loc != 2) continue;
            return false;
        }
        return true;
    }

    protected boolean isAllTestComponentsInTargetInterior(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        for (Coordinate p : coords) {
            int loc = this.targetPointLocator.locate(p);
            if (loc == 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isAnyTestComponentInTarget(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        for (Coordinate p : coords) {
            int loc = this.targetPointLocator.locate(p);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllTestPointsInTarget(Geometry testGeom) {
        for (int i = 0; i < testGeom.getNumGeometries(); ++i) {
            Point pt = (Point)testGeom.getGeometryN(i);
            Coordinate p = pt.getCoordinate();
            int loc = this.targetPointLocator.locate(p);
            if (loc != 2) continue;
            return false;
        }
        return true;
    }

    protected boolean isAnyTestPointInTargetInterior(Geometry testGeom) {
        for (int i = 0; i < testGeom.getNumGeometries(); ++i) {
            Point pt = (Point)testGeom.getGeometryN(i);
            Coordinate p = pt.getCoordinate();
            int loc = this.targetPointLocator.locate(p);
            if (loc != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isAnyTargetComponentInAreaTest(Geometry testGeom, List targetRepPts) {
        SimplePointInAreaLocator piaLoc = new SimplePointInAreaLocator(testGeom);
        for (Coordinate p : targetRepPts) {
            int loc = piaLoc.locate(p);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }
}

