/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm.locate;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.RayCrossingCounter;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineSegment;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygonal;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.LinearComponentExtracter;
import com.hazelcast.shaded.org.locationtech.jts.index.ArrayListVisitor;
import com.hazelcast.shaded.org.locationtech.jts.index.ItemVisitor;
import com.hazelcast.shaded.org.locationtech.jts.index.intervalrtree.SortedPackedIntervalRTree;
import java.util.ArrayList;
import java.util.List;

public class IndexedPointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry geom;
    private volatile IntervalIndexedGeometry index = null;

    public IndexedPointInAreaLocator(Geometry g2) {
        if (!(g2 instanceof Polygonal) && !(g2 instanceof LinearRing)) {
            throw new IllegalArgumentException("Argument must be Polygonal or LinearRing");
        }
        this.geom = g2;
    }

    @Override
    public int locate(Coordinate p) {
        if (this.index == null) {
            this.createIndex();
        }
        RayCrossingCounter rcc = new RayCrossingCounter(p);
        SegmentVisitor visitor = new SegmentVisitor(rcc);
        this.index.query(p.y, p.y, visitor);
        return rcc.getLocation();
    }

    private synchronized void createIndex() {
        if (this.index == null) {
            this.index = new IntervalIndexedGeometry(this.geom);
            this.geom = null;
        }
    }

    private static class IntervalIndexedGeometry {
        private final boolean isEmpty;
        private final SortedPackedIntervalRTree index = new SortedPackedIntervalRTree();

        public IntervalIndexedGeometry(Geometry geom) {
            if (geom.isEmpty()) {
                this.isEmpty = true;
            } else {
                this.isEmpty = false;
                this.init(geom);
            }
        }

        private void init(Geometry geom) {
            List lines = LinearComponentExtracter.getLines(geom);
            for (LineString line : lines) {
                Coordinate[] pts = line.getCoordinates();
                this.addLine(pts);
            }
        }

        private void addLine(Coordinate[] pts) {
            for (int i = 1; i < pts.length; ++i) {
                LineSegment seg = new LineSegment(pts[i - 1], pts[i]);
                double min2 = Math.min(seg.p0.y, seg.p1.y);
                double max = Math.max(seg.p0.y, seg.p1.y);
                this.index.insert(min2, max, seg);
            }
        }

        public List query(double min2, double max) {
            if (this.isEmpty) {
                return new ArrayList();
            }
            ArrayListVisitor visitor = new ArrayListVisitor();
            this.index.query(min2, max, visitor);
            return visitor.getItems();
        }

        public void query(double min2, double max, ItemVisitor visitor) {
            if (this.isEmpty) {
                return;
            }
            this.index.query(min2, max, visitor);
        }
    }

    private static class SegmentVisitor
    implements ItemVisitor {
        private final RayCrossingCounter counter;

        public SegmentVisitor(RayCrossingCounter counter) {
            this.counter = counter;
        }

        @Override
        public void visitItem(Object item) {
            LineSegment seg = (LineSegment)item;
            this.counter.countSegment(seg.getCoordinate(0), seg.getCoordinate(1));
        }
    }
}

