/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json.compiler;

import com.hazelcast.shaded.org.antlr.v4.runtime.BailErrorStrategy;
import com.hazelcast.shaded.org.antlr.v4.runtime.BaseErrorListener;
import com.hazelcast.shaded.org.antlr.v4.runtime.CharStreams;
import com.hazelcast.shaded.org.antlr.v4.runtime.CommonTokenStream;
import com.hazelcast.shaded.org.antlr.v4.runtime.RecognitionException;
import com.hazelcast.shaded.org.antlr.v4.runtime.Recognizer;
import com.hazelcast.shaded.org.antlr.v4.runtime.tree.ParseTree;
import com.hazelcast.shaded.org.antlr.v4.runtime.tree.TerminalNode;
import com.hazelcast.shaded.org.jsfr.json.compiler.JsonPathBaseVisitor;
import com.hazelcast.shaded.org.jsfr.json.compiler.JsonPathLexer;
import com.hazelcast.shaded.org.jsfr.json.compiler.JsonPathParser;
import com.hazelcast.shaded.org.jsfr.json.exception.JsonPathCompilerException;
import com.hazelcast.shaded.org.jsfr.json.filter.ConstantPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.EqualityBoolPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.EqualityNullPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.EqualityNumPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.EqualityStrPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.EqualityTypePredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.ExistencePredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.FilterBuilder;
import com.hazelcast.shaded.org.jsfr.json.filter.GreaterOrEqualThanNumPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.GreaterThanNumPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.ItemMethod;
import com.hazelcast.shaded.org.jsfr.json.filter.JsonPathFilter;
import com.hazelcast.shaded.org.jsfr.json.filter.LessOrEqualThanNumPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.LessThanNumPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.MatchRegexPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.NotEqualityBoolPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.NotEqualityNullPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.NotEqualityNumPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.NotEqualityStrPredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.NotEqualityTypePredicate;
import com.hazelcast.shaded.org.jsfr.json.filter.Type;
import com.hazelcast.shaded.org.jsfr.json.path.JsonPath;
import com.hazelcast.shaded.org.jsfr.json.path.SyntaxMode;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class JsonPathCompiler
extends JsonPathBaseVisitor<Void> {
    private JsonPath.Builder pathBuilder;
    private FilterBuilder filterBuilder;
    private JsonPath.Builder filterPathBuilder;

    @Override
    public Void visitPath(JsonPathParser.PathContext ctx) {
        SyntaxMode mode;
        if (ctx.syntaxMode() != null) {
            mode = SyntaxMode.parse(ctx.syntaxMode().getText());
            if (mode == null) {
                throw new InputMismatchException("Invalid json path mode. Supported: lax");
            }
        } else {
            mode = SyntaxMode.LAX;
        }
        this.pathBuilder = JsonPath.Builder.start(mode);
        return (Void)super.visitPath(ctx);
    }

    private JsonPath.Builder currentPathBuilder() {
        return this.filterPathBuilder != null ? this.filterPathBuilder : this.pathBuilder;
    }

    @Override
    public Void visitSearchChild(JsonPathParser.SearchChildContext ctx) {
        String key = JsonPathCompiler.getKeyOrQuotedString(ctx);
        this.currentPathBuilder().scan();
        JsonPathParser.ArrayContext array = ctx.array();
        if (array != null) {
            this.array(key, array);
        } else {
            this.currentPathBuilder().child(key);
        }
        return (Void)super.visitSearchChild(ctx);
    }

    @Override
    public Void visitChildNode(JsonPathParser.ChildNodeContext ctx) {
        String key = JsonPathCompiler.getKeyOrQuotedString(ctx);
        JsonPathParser.ArrayContext array = ctx.array();
        if (array != null) {
            this.array(key, array);
        } else {
            this.currentPathBuilder().child(key);
        }
        return (Void)super.visitChildNode(ctx);
    }

    @Override
    public Void visitRelativePath(JsonPathParser.RelativePathContext ctx) {
        if (ctx.array() != null) {
            this.array(null, ctx.array());
        }
        return (Void)super.visitRelativePath(ctx);
    }

    @Override
    public Void visitChildrenNode(JsonPathParser.ChildrenNodeContext ctx) {
        int i = 0;
        String[] strings = new String[ctx.QUOTED_STRING().size()];
        for (TerminalNode node : ctx.QUOTED_STRING()) {
            String quotedString = node.getText();
            strings[i++] = JsonPathCompiler.unescapeString(quotedString);
        }
        this.currentPathBuilder().children(strings);
        return (Void)super.visitChildren(ctx);
    }

    @Override
    public Void visitAnyChild(JsonPathParser.AnyChildContext ctx) {
        this.currentPathBuilder().anyChild();
        return (Void)super.visitAnyChild(ctx);
    }

    @Override
    public Void visitAny(JsonPathParser.AnyContext ctx) {
        this.currentPathBuilder().any();
        return (Void)super.visitAny(ctx);
    }

    @Override
    public Void visitFilterExpr(JsonPathParser.FilterExprContext ctx) {
        Void rst;
        if (ctx.NegationOperator() != null) {
            this.filterBuilder.startNegationPredicate();
            rst = (Void)super.visitFilterExpr(ctx);
            this.filterBuilder.endNegationAndPredicate();
        } else if (ctx.AndOperator() != null) {
            this.filterBuilder.startAndPredicate();
            rst = (Void)super.visitFilterExpr(ctx);
            this.filterBuilder.endAndPredicate();
        } else if (ctx.OrOperator() != null) {
            this.filterBuilder.startOrPredicate();
            rst = (Void)super.visitFilterExpr(ctx);
            this.filterBuilder.endOrPredicate();
        } else {
            rst = (Void)super.visitFilterExpr(ctx);
        }
        return rst;
    }

    private JsonPath.Builder createFilterPathBuilder() {
        return JsonPath.Builder.startFilterPath();
    }

    @Override
    public Void visitFilterEqualNum(JsonPathParser.FilterEqualNumContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterEqualNum(ctx);
        this.filterBuilder.append(new EqualityNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterNEqualNum(JsonPathParser.FilterNEqualNumContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterNEqualNum(ctx);
        this.filterBuilder.append(new NotEqualityNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterEqualBool(JsonPathParser.FilterEqualBoolContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterEqualBool(ctx);
        this.filterBuilder.append(new EqualityBoolPredicate(this.filterPathBuilder.build(), Boolean.parseBoolean(ctx.BOOL().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterNEqualBool(JsonPathParser.FilterNEqualBoolContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterNEqualBool(ctx);
        this.filterBuilder.append(new NotEqualityBoolPredicate(this.filterPathBuilder.build(), Boolean.parseBoolean(ctx.BOOL().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterEqualNull(JsonPathParser.FilterEqualNullContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterEqualNull(ctx);
        this.filterBuilder.append(new EqualityNullPredicate(this.filterPathBuilder.build()));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterNEqualNull(JsonPathParser.FilterNEqualNullContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterNEqualNull(ctx);
        this.filterBuilder.append(new NotEqualityNullPredicate(this.filterPathBuilder.build()));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterExist(JsonPathParser.FilterExistContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterExist(ctx);
        this.filterBuilder.append(new ExistencePredicate(this.filterPathBuilder.build()));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterGtNum(JsonPathParser.FilterGtNumContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterGtNum(ctx);
        this.filterBuilder.append(new GreaterThanNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterGeNum(JsonPathParser.FilterGeNumContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterGeNum(ctx);
        this.filterBuilder.append(new GreaterOrEqualThanNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterLtNum(JsonPathParser.FilterLtNumContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterLtNum(ctx);
        this.filterBuilder.append(new LessThanNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterLeNum(JsonPathParser.FilterLeNumContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterLeNum(ctx);
        this.filterBuilder.append(new LessOrEqualThanNumPredicate(this.filterPathBuilder.build(), new BigDecimal(ctx.NUM().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterEqualStr(JsonPathParser.FilterEqualStrContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterEqualStr(ctx);
        this.filterBuilder.append(new EqualityStrPredicate(this.filterPathBuilder.build(), JsonPathCompiler.unescapeString(ctx.QUOTED_STRING().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterNEqualStr(JsonPathParser.FilterNEqualStrContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterNEqualStr(ctx);
        this.filterBuilder.append(new NotEqualityStrPredicate(this.filterPathBuilder.build(), JsonPathCompiler.unescapeString(ctx.QUOTED_STRING().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterMatchRegex(JsonPathParser.FilterMatchRegexContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterMatchRegex(ctx);
        this.filterBuilder.append(new MatchRegexPredicate(this.filterPathBuilder.build(), JsonPathCompiler.toPattern(ctx.QUOTED_STRING().getText())));
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterItemMethodEqual(JsonPathParser.FilterItemMethodEqualContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterItemMethodEqual(ctx);
        ItemMethod itemMethod = JsonPathCompiler.getItemMethod(ctx.itemMethod());
        if (itemMethod == ItemMethod.TYPE) {
            Type type = JsonPathCompiler.getType(ctx.QUOTED_STRING());
            if (type == null) {
                this.filterBuilder.append(new ConstantPredicate(this.filterPathBuilder.build(), false));
            } else {
                this.filterBuilder.append(new EqualityTypePredicate(this.filterPathBuilder.build(), type));
            }
        } else {
            throw new InputMismatchException("Unsupported item method: " + (Object)((Object)itemMethod));
        }
        this.filterPathBuilder = null;
        return rst;
    }

    @Override
    public Void visitFilterItemMethodNEqual(JsonPathParser.FilterItemMethodNEqualContext ctx) {
        this.filterPathBuilder = this.createFilterPathBuilder();
        Void rst = (Void)super.visitFilterItemMethodNEqual(ctx);
        ItemMethod itemMethod = JsonPathCompiler.getItemMethod(ctx.itemMethod());
        if (itemMethod == ItemMethod.TYPE) {
            Type type = JsonPathCompiler.getType(ctx.QUOTED_STRING());
            if (type == null) {
                this.filterBuilder.append(new ConstantPredicate(this.filterPathBuilder.build(), true));
            } else {
                this.filterBuilder.append(new NotEqualityTypePredicate(this.filterPathBuilder.build(), type));
            }
        } else {
            throw new InputMismatchException("Unsupported item method: " + (Object)((Object)itemMethod));
        }
        this.filterPathBuilder = null;
        return rst;
    }

    static String unescapeString(String quotedString) {
        assert (quotedString.startsWith("\"") && quotedString.endsWith("\""));
        StringBuilder res = new StringBuilder(quotedString.length() - 2);
        int end = quotedString.length() - 1;
        for (int i = 1; i < end; ++i) {
            int ch = quotedString.charAt(i);
            assert (ch != 34) : "unexpected end quote";
            if (ch == 92) {
                ch = quotedString.charAt(++i);
                switch (ch) {
                    case 34: 
                    case 39: 
                    case 47: 
                    case 92: {
                        break;
                    }
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 117: {
                        if (i + 4 >= end) {
                            throw new JsonPathCompilerException("Invalid escape");
                        }
                        ch = (char)Integer.parseInt("" + quotedString.charAt(++i) + quotedString.charAt(++i) + quotedString.charAt(++i) + quotedString.charAt(++i), 16);
                        break;
                    }
                    default: {
                        throw new JsonPathCompilerException("Invalid escape");
                    }
                }
            }
            res.append((char)ch);
        }
        return res.toString();
    }

    private static String getKeyOrQuotedString(JsonPathParser.ChildNodeContext ctx) {
        return ctx.KEY() != null ? ctx.KEY().getText() : JsonPathCompiler.unescapeString(ctx.QUOTED_STRING().getText());
    }

    private static String getKeyOrQuotedString(JsonPathParser.SearchChildContext ctx) {
        return ctx.KEY() != null ? ctx.KEY().getText() : JsonPathCompiler.unescapeString(ctx.QUOTED_STRING().getText());
    }

    private static Pattern toPattern(String str) {
        if (!str.startsWith("\"") || !str.endsWith("\"")) {
            throw new JsonPathCompilerException("Invalid regex literal pattern");
        }
        String unquoted = JsonPathCompiler.unescapeString(str);
        return Pattern.compile(unquoted);
    }

    private void array(String key, JsonPathParser.ArrayContext ctx) {
        JsonPathFilter jsonPathFilter = null;
        if (ctx.filter() != null) {
            this.filterBuilder = new FilterBuilder();
            super.visitFilter(ctx.filter());
            jsonPathFilter = this.filterBuilder.build();
        }
        JsonPath.Builder pathBuilder = this.currentPathBuilder();
        if (ctx.index() != null) {
            JsonPathCompiler.arrayIndex(key, jsonPathFilter, pathBuilder, ctx.index());
        } else if (ctx.indexes() != null) {
            JsonPathCompiler.arrayIndexes(key, jsonPathFilter, pathBuilder, ctx.indexes());
        } else if (ctx.ANY_INDEX() != null) {
            JsonPathCompiler.arrayWildcard(key, jsonPathFilter, pathBuilder);
        }
    }

    private static void arrayIndex(String key, JsonPathFilter filter, JsonPath.Builder builder, JsonPathParser.IndexContext ctx) {
        builder.array(key, filter, Integer.parseInt(ctx.NUM().getText()));
    }

    private static void arrayIndexes(String key, JsonPathFilter filter, JsonPath.Builder builder, JsonPathParser.IndexesContext ctx) {
        HashSet<Integer> indexes = new HashSet<Integer>();
        TreeMap<Integer, Integer> ranges = new TreeMap<Integer, Integer>();
        List children = ctx.children;
        assert (((TerminalNode)children.get(0)).getSymbol().getType() == 21);
        assert (((TerminalNode)children.get(children.size() - 1)).getSymbol().getType() == 22);
        for (int i = 1; i < children.size() - 1; ++i) {
            if (((TerminalNode)children.get(i)).getSymbol().getType() == 24) continue;
            int index = Integer.parseInt(((ParseTree)children.get(i)).getText());
            if (i + 1 < children.size() && ((TerminalNode)children.get(i + 1)).getSymbol().getType() == 23) {
                int rangeEnd = Integer.parseInt(((ParseTree)children.get(i += 2)).getText());
                if (rangeEnd < index) {
                    throw new RuntimeException("Array subscript invalid range");
                }
                ranges.put(index, rangeEnd);
                continue;
            }
            indexes.add(index);
        }
        builder.array(key, filter, indexes, ranges);
    }

    private static void arrayWildcard(String key, JsonPathFilter filter, JsonPath.Builder builder) {
        builder.arrayWildcard(key, filter);
    }

    private static ItemMethod getItemMethod(JsonPathParser.ItemMethodContext ctx) {
        String methodName = ctx.KEY().getText();
        ItemMethod itemMethod = ItemMethod.from(methodName);
        if (itemMethod == null) {
            throw new InputMismatchException(String.format("Invalid item method %s. Supported: %s", methodName, Arrays.toString((Object[])ItemMethod.values())));
        }
        return itemMethod;
    }

    private static Type getType(TerminalNode quoteString) {
        String typeName = JsonPathCompiler.unescapeString(quoteString.getText());
        return Type.from(typeName);
    }

    public static JsonPath[] compile(String ... paths) {
        JsonPath[] jsonPaths = new JsonPath[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            jsonPaths[i] = JsonPathCompiler.compile(paths[i]);
        }
        return jsonPaths;
    }

    public static JsonPath compile(String path) {
        JsonPathParser.PathContext tree;
        JsonPathLexer lexer = new JsonPathLexer(CharStreams.fromString(path));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JsonPathParser parser = new JsonPathParser(tokens);
        parser.setErrorHandler(new BailErrorStrategy());
        parser.removeErrorListeners();
        lexer.removeErrorListeners();
        ThrowingErrorListener errorListener = new ThrowingErrorListener();
        parser.addErrorListener(errorListener);
        lexer.addErrorListener(errorListener);
        try {
            tree = parser.path();
        }
        catch (JsonPathCompilerException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw JsonPathCompilerException.from(e);
        }
        JsonPathCompiler compiler = new JsonPathCompiler();
        compiler.visit(tree);
        return compiler.pathBuilder.build();
    }

    private static class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new JsonPathCompilerException("Line " + line + ", column " + charPositionInLine + ": " + msg);
        }
    }
}

