/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json;

import com.hazelcast.shaded.org.jsfr.json.path.ArrayIndex;
import com.hazelcast.shaded.org.jsfr.json.path.ChildNode;
import com.hazelcast.shaded.org.jsfr.json.path.JsonPath;
import com.hazelcast.shaded.org.jsfr.json.path.PathOperator;

class JsonPosition
extends JsonPath {
    JsonPosition() {
    }

    static JsonPosition start() {
        return new JsonPosition();
    }

    void stepIntoObject() {
        PathOperator next;
        if (this.operators.length > this.size && (next = this.operators[this.size]) instanceof ChildNode) {
            ++this.size;
            ((ChildNode)next).setKey(null);
            return;
        }
        this.push(new ChildNode(null));
    }

    void updateObjectEntry(String key) {
        ((ChildNode)this.peek()).setKey(key);
    }

    void stepOutObject() {
        this.pop();
    }

    void stepIntoArray() {
        PathOperator last = this.peek();
        this.pushArray(last);
    }

    void stepOutArray() {
        this.popArray(this.peek());
    }

    private void popArray(PathOperator node) {
        if (node instanceof ArrayIndex) {
            this.pop();
            ArrayIndex indexNode = (ArrayIndex)node;
            if (indexNode.getKey() != null) {
                this.push(new ChildNode(indexNode.getKey()));
            }
        }
    }

    private void pushArray(PathOperator node) {
        if (node instanceof ChildNode && node.getType() == PathOperator.Type.OBJECT) {
            this.pop();
            this.push(new ArrayIndex(((ChildNode)node).getKey()));
        } else {
            PathOperator next;
            if (this.operators.length > this.size && (next = this.operators[this.size]) instanceof ArrayIndex) {
                ++this.size;
                ((ArrayIndex)next).reset();
                return;
            }
            this.push(new ArrayIndex(null));
        }
    }
}

