/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.util;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PrecedenceClimbingParser {
    private @Nullable Token first;
    private @Nullable Token last;

    private PrecedenceClimbingParser(List<Token> tokens) {
        Token p = null;
        for (Token token : tokens) {
            if (p != null) {
                p.next = token;
            } else {
                this.first = token;
            }
            token.previous = p;
            token.next = null;
            p = token;
        }
        this.last = p;
    }

    public Token atom(Object o) {
        return new Token(Type.ATOM, o, -1, -1);
    }

    public Call call(Op op, ImmutableList<Token> args) {
        return new Call(op, args);
    }

    public Op infix(Object o, int precedence, boolean left) {
        return new Op(Type.INFIX, o, precedence * 2 + (left ? 0 : 1), precedence * 2 + (left ? 1 : 0));
    }

    public Op prefix(Object o, int precedence) {
        return new Op(Type.PREFIX, o, -1, precedence * 2);
    }

    public Op postfix(Object o, int precedence) {
        return new Op(Type.POSTFIX, o, precedence * 2, -1);
    }

    public SpecialOp special(Object o, int leftPrec, int rightPrec, Special special) {
        return new SpecialOp(o, leftPrec * 2, rightPrec * 2, special);
    }

    public @Nullable Token parse() {
        this.partialParse();
        if (this.first != this.last) {
            throw new AssertionError((Object)("could not find next operator to reduce: " + this));
        }
        return this.first;
    }

    public void partialParse() {
        block6: while (true) {
            Op op;
            if ((op = this.highest()) == null) {
                return;
            }
            switch (op.type) {
                case POSTFIX: {
                    Token previous = Objects.requireNonNull(op.previous, () -> "previous of " + op);
                    Call t2 = this.call(op, ImmutableList.of(previous));
                    this.replace(t2, previous.previous, op.next);
                    continue block6;
                }
                case PREFIX: {
                    Token next = Objects.requireNonNull(op.next, () -> "next of " + op);
                    Call t2 = this.call(op, ImmutableList.of(next));
                    this.replace(t2, op.previous, next.next);
                    continue block6;
                }
                case INFIX: {
                    Token previous = Objects.requireNonNull(op.previous, () -> "previous of " + op);
                    Token next = Objects.requireNonNull(op.next, () -> "next of " + op);
                    Call t2 = this.call(op, ImmutableList.of(previous, next));
                    this.replace(t2, previous.previous, next.next);
                    continue block6;
                }
                case SPECIAL: {
                    Result r = ((SpecialOp)op).special.apply(this, (SpecialOp)op);
                    Objects.requireNonNull(r, "r");
                    this.replace(r.replacement, r.first.previous, r.last.next);
                    continue block6;
                }
            }
            break;
        }
        throw new AssertionError();
    }

    public String toString() {
        return Util.commaList(this.all());
    }

    public List<Token> all() {
        return new TokenList();
    }

    private void replace(Token t2, @Nullable Token previous, @Nullable Token next) {
        t2.previous = previous;
        t2.next = next;
        if (previous == null) {
            this.first = t2;
        } else {
            previous.next = t2;
        }
        if (next == null) {
            this.last = t2;
        } else {
            next.previous = t2;
        }
    }

    private @Nullable Op highest() {
        int p = -1;
        Op highest = null;
        Token t2 = this.first;
        while (t2 != null) {
            if (!(t2.left <= p && t2.right <= p || t2.left >= 0 && t2.left < PrecedenceClimbingParser.prevRight(t2.previous) || t2.right >= 0 && t2.right < PrecedenceClimbingParser.nextLeft(t2.next))) {
                p = Math.max(t2.left, t2.right);
                highest = (Op)t2;
            }
            t2 = t2.next;
        }
        return highest;
    }

    private static int prevRight(@Nullable Token token) {
        while (token != null) {
            if (token.type == Type.POSTFIX) {
                return Integer.MAX_VALUE;
            }
            if (token.right >= 0) {
                return token.right;
            }
            token = token.previous;
        }
        return -1;
    }

    private static int nextLeft(@Nullable Token token) {
        while (token != null) {
            if (token.type == Type.PREFIX) {
                return Integer.MAX_VALUE;
            }
            if (token.left >= 0) {
                return token.left;
            }
            token = token.next;
        }
        return -1;
    }

    public String print(Token token) {
        return token.toString();
    }

    public PrecedenceClimbingParser copy(int start, Predicate<Token> predicate) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Token token : Util.skip(this.all(), start)) {
            if (predicate.test(token)) break;
            tokens.add(token.copy());
        }
        return new PrecedenceClimbingParser(tokens);
    }

    private class TokenList
    extends AbstractList<Token> {
        private TokenList() {
        }

        @Override
        public Token get(int index) {
            Token t2 = PrecedenceClimbingParser.this.first;
            while (t2 != null) {
                if (index-- == 0) {
                    return t2;
                }
                t2 = t2.next;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            int n = 0;
            Token t2 = PrecedenceClimbingParser.this.first;
            while (t2 != null) {
                ++n;
                t2 = t2.next;
            }
            return n;
        }

        @Override
        public Token remove(int index) {
            Token t2 = this.get(index);
            if (t2.previous == null) {
                PrecedenceClimbingParser.this.first = t2.next;
            } else {
                t2.previous.next = t2.next;
            }
            if (t2.next == null) {
                PrecedenceClimbingParser.this.last = t2.previous;
            } else {
                t2.next.previous = t2.previous;
            }
            return t2;
        }

        @Override
        public Token set(int index, Token element) {
            Token t2 = this.get(index);
            element.previous = t2.previous;
            if (t2.previous == null) {
                PrecedenceClimbingParser.this.first = element;
            } else {
                t2.previous.next = element;
            }
            element.next = t2.next;
            if (t2.next == null) {
                PrecedenceClimbingParser.this.last = element;
            } else {
                t2.next.previous = element;
            }
            return t2;
        }
    }

    public static class Builder {
        final List<Token> tokens = new ArrayList<Token>();
        private final PrecedenceClimbingParser dummy = new PrecedenceClimbingParser(ImmutableList.of());

        private Builder add(Token t2) {
            this.tokens.add(t2);
            return this;
        }

        public Builder atom(Object o) {
            return this.add(this.dummy.atom(o));
        }

        public Builder call(Op op, Token arg0, Token arg1) {
            return this.add(this.dummy.call(op, ImmutableList.of(arg0, arg1)));
        }

        public Builder infix(Object o, int precedence, boolean left) {
            return this.add(this.dummy.infix(o, precedence, left));
        }

        public Builder prefix(Object o, int precedence) {
            return this.add(this.dummy.prefix(o, precedence));
        }

        public Builder postfix(Object o, int precedence) {
            return this.add(this.dummy.postfix(o, precedence));
        }

        public Builder special(Object o, int leftPrec, int rightPrec, Special special) {
            return this.add(this.dummy.special(o, leftPrec, rightPrec, special));
        }

        public PrecedenceClimbingParser build() {
            return new PrecedenceClimbingParser(this.tokens);
        }
    }

    public static class Result {
        final Token first;
        final Token last;
        final Token replacement;

        public Result(Token first, Token last, Token replacement) {
            this.first = first;
            this.last = last;
            this.replacement = replacement;
        }
    }

    public static interface Special {
        public Result apply(PrecedenceClimbingParser var1, SpecialOp var2);
    }

    public static class Call
    extends Token {
        public final Op op;
        public final ImmutableList<Token> args;

        Call(Op op, ImmutableList<Token> args) {
            super(Type.CALL, null, -1, -1);
            this.op = op;
            this.args = args;
        }

        @Override
        public Token copy() {
            return new Call(this.op, this.args);
        }

        @Override
        public String toString() {
            return this.print(new StringBuilder()).toString();
        }

        @Override
        protected StringBuilder print(StringBuilder b) {
            switch (this.op.type) {
                case PREFIX: {
                    b.append('(');
                    this.printOp(b, false, true);
                    ((Token)this.args.get(0)).print(b);
                    return b.append(')');
                }
                case POSTFIX: {
                    b.append('(');
                    ((Token)this.args.get(0)).print(b);
                    return this.printOp(b, true, false).append(')');
                }
                case INFIX: {
                    b.append('(');
                    ((Token)this.args.get(0)).print(b);
                    this.printOp(b, true, true);
                    ((Token)this.args.get(1)).print(b);
                    return b.append(')');
                }
                case SPECIAL: {
                    this.printOp(b, false, false).append('(');
                    for (Ord<Token> arg : Ord.zip(this.args)) {
                        if (arg.i > 0) {
                            b.append(", ");
                        }
                        ((Token)arg.e).print(b);
                    }
                    return b.append(')');
                }
            }
            throw new AssertionError();
        }

        private StringBuilder printOp(StringBuilder b, boolean leftSpace, boolean rightSpace) {
            String s2 = String.valueOf(this.op.o);
            if (leftSpace) {
                b.append(' ');
            }
            b.append(s2);
            if (rightSpace) {
                b.append(' ');
            }
            return b;
        }
    }

    public static class SpecialOp
    extends Op {
        public final Special special;

        SpecialOp(Object o, int left, int right, Special special) {
            super(Type.SPECIAL, o, left, right);
            this.special = special;
        }

        @Override
        public Token copy() {
            return new SpecialOp(this.o(), this.left, this.right, this.special);
        }
    }

    public static class Op
    extends Token {
        Op(Type type, Object o, int left, int right) {
            super(type, o, left, right);
        }

        @Override
        public Object o() {
            return Nullness.castNonNull(super.o());
        }

        @Override
        public Token copy() {
            return new Op(this.type, this.o(), this.left, this.right);
        }
    }

    public static class Token {
        @Nullable Token previous;
        @Nullable Token next;
        public final Type type;
        public final @Nullable Object o;
        final int left;
        final int right;

        Token(Type type, @Nullable Object o, int left, int right) {
            this.type = type;
            this.o = o;
            this.left = left;
            this.right = right;
        }

        public @Nullable Object o() {
            return this.o;
        }

        public String toString() {
            return String.valueOf(this.o);
        }

        protected StringBuilder print(StringBuilder b) {
            return b.append(this.o);
        }

        public Token copy() {
            return new Token(this.type, this.o, this.left, this.right);
        }
    }

    public static enum Type {
        ATOM,
        CALL,
        PREFIX,
        INFIX,
        POSTFIX,
        SPECIAL;

    }
}

