/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.type;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeTransform;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public class SqlTypeTransformCascade
implements SqlReturnTypeInference {
    private final SqlReturnTypeInference rule;
    private final ImmutableList<SqlTypeTransform> transforms;

    public SqlTypeTransformCascade(SqlReturnTypeInference rule, SqlTypeTransform ... transforms) {
        Preconditions.checkArgument(transforms.length > 0);
        this.rule = Objects.requireNonNull(rule, "rule");
        this.transforms = ImmutableList.copyOf(transforms);
    }

    @Override
    public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = this.rule.inferReturnType(opBinding);
        if (ret == null) {
            return null;
        }
        for (SqlTypeTransform transform : this.transforms) {
            ret = transform.transformType(opBinding, ret);
        }
        return ret;
    }
}

