/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.type;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.type.NonNullableAccessors;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.apache.calcite.util.Static;

public class ArrayElementOperandTypeChecker
implements SqlOperandTypeChecker {
    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode op0 = callBinding.operand(0);
        if (!OperandTypes.ARRAY.checkSingleOperandType(callBinding, op0, 0, throwOnFailure)) {
            return false;
        }
        RelDataType arrayComponentType = NonNullableAccessors.getComponentTypeOrThrow(SqlTypeUtil.deriveType(callBinding, op0));
        SqlNode op1 = callBinding.operand(1);
        RelDataType aryType1 = SqlTypeUtil.deriveType(callBinding, op1);
        RelDataType biggest = callBinding.getTypeFactory().leastRestrictive(ImmutableList.of(arrayComponentType, aryType1));
        if (biggest == null) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(arrayComponentType.toString(), aryType1.toString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<ARRAY> " + opName + " <ARRAY>";
    }
}

