/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeTransforms;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Map;

public class SqlTimestampAddFunction
extends SqlFunction {
    private static final Map<TimeUnit, Integer> FRAC_SECOND_PRECISION_MAP = ImmutableMap.of(TimeUnit.MILLISECOND, 3, TimeUnit.MICROSECOND, 6, TimeUnit.NANOSECOND, 9);
    private static final SqlReturnTypeInference RETURN_TYPE_INFERENCE = opBinding -> SqlTimestampAddFunction.deduceType(opBinding.getTypeFactory(), opBinding.getOperandLiteralValue(0, TimeUnit.class), opBinding.getOperandType(2));

    @Deprecated
    public static RelDataType deduceType(RelDataTypeFactory typeFactory, @Nullable TimeUnit timeUnit, RelDataType operandType1, RelDataType operandType2) {
        RelDataType type = SqlTimestampAddFunction.deduceType(typeFactory, timeUnit, operandType2);
        return typeFactory.createTypeWithNullability(type, operandType1.isNullable() || operandType2.isNullable());
    }

    static RelDataType deduceType(RelDataTypeFactory typeFactory, @Nullable TimeUnit timeUnit, RelDataType datetimeType) {
        TimeUnit timeUnit2 = Util.first(timeUnit, TimeUnit.EPOCH);
        SqlTypeName typeName = datetimeType.getSqlTypeName();
        switch (timeUnit2) {
            case MICROSECOND: 
            case MILLISECOND: 
            case NANOSECOND: {
                return typeFactory.createSqlType(typeName, Math.max(FRAC_SECOND_PRECISION_MAP.getOrDefault((Object)timeUnit2, 0), datetimeType.getPrecision()));
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                if (datetimeType.getFamily() == SqlTypeFamily.TIME) {
                    return datetimeType;
                }
                if (datetimeType.getFamily() == SqlTypeFamily.TIMESTAMP) {
                    return typeFactory.createSqlType(typeName, datetimeType.getPrecision());
                }
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
        }
        return datetimeType;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        validator.validateTimeFrame((SqlIntervalQualifier)call.getOperandList().get(0));
    }

    SqlTimestampAddFunction(String name) {
        super(name, SqlKind.TIMESTAMP_ADD, RETURN_TYPE_INFERENCE.andThen(SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
    }
}

