/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCharStringLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlMonotonicUnaryFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlFloorFunction
extends SqlMonotonicUnaryFunction {
    private SqlFloorFunction(String name, SqlKind kind, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory funcType) {
        super(name, kind, returnTypeInference, operandTypeInference, operandTypeChecker, funcType);
    }

    public SqlFloorFunction(SqlKind kind) {
        super(kind.name(), kind, ReturnTypes.ARG0_OR_EXACT_NO_SCALE, null, OperandTypes.NUMERIC_OR_INTERVAL.or(OperandTypes.sequence("'" + (Object)((Object)kind) + "(<DATE> TO <TIME_UNIT>)'\n'" + (Object)((Object)kind) + "(<TIME> TO <TIME_UNIT>)'\n'" + (Object)((Object)kind) + "(<TIMESTAMP> TO <TIME_UNIT>)'", OperandTypes.DATETIME, OperandTypes.ANY)), SqlFunctionCategory.NUMERIC);
        Preconditions.checkArgument(kind == SqlKind.FLOOR || kind == SqlKind.CEIL);
    }

    public SqlFloorFunction withName(String name) {
        return new SqlFloorFunction(name, this.getKind(), this.getReturnTypeInference(), this.getOperandTypeInference(), this.getOperandTypeChecker(), this.getFunctionType());
    }

    public SqlFloorFunction withReturnTypeInference(SqlReturnTypeInference returnTypeInference) {
        return new SqlFloorFunction(this.getName(), this.getKind(), returnTypeInference, this.getOperandTypeInference(), this.getOperandTypeChecker(), this.getFunctionType());
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0).unstrict();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        if (call.operandCount() == 2) {
            ((SqlNode)call.operand(0)).unparse(writer, 0, 100);
            writer.sep("TO");
            SqlIntervalQualifier.asIdentifier(call.operand(1)).unparse(writer, 100, 0);
        } else {
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        }
        writer.endFunCall(frame);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            validator.setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        if (call.operandCount() > 1) {
            validator.validateTimeFrame((SqlIntervalQualifier)call.getOperandList().get(1));
        }
    }

    @Override
    public String getName() {
        return this.kind.name();
    }

    public static SqlCall replaceTimeUnitOperand(SqlCall call, String literal, SqlParserPos pos) {
        SqlCharStringLiteral literalNode = SqlLiteral.createCharString(literal, null, pos);
        return call.getOperator().createCall(call.getFunctionQuantifier(), pos, call.getOperandList().get(0), literalNode);
    }

    public static void unparseDatetimeFunction(SqlWriter writer, SqlCall call, String funName, Boolean datetimeFirst) {
        SqlCall call1;
        SqlFunction func = new SqlFunction(funName, SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
        if (datetimeFirst.booleanValue()) {
            call1 = call;
        } else {
            Object op1 = call.operand(0);
            Object op2 = call.operand(1);
            call1 = call.getOperator().createCall(call.getParserPosition(), new SqlNode[]{op2, op1});
        }
        SqlUtil.unparseFunctionSyntax(func, writer, call1, false);
    }
}

