/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class SqlWithItem
extends SqlCall {
    public SqlIdentifier name;
    public @Nullable SqlNodeList columnList;
    public SqlNode query;

    public SqlWithItem(SqlParserPos pos, SqlIdentifier name, @Nullable SqlNodeList columnList, SqlNode query) {
        super(pos);
        this.name = name;
        this.columnList = columnList;
        this.query = query;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.WITH_ITEM;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList, this.query);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.name = (SqlIdentifier)operand;
                break;
            }
            case 1: {
                this.columnList = (SqlNodeList)operand;
                break;
            }
            case 2: {
                this.query = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public SqlOperator getOperator() {
        return SqlWithItemOperator.INSTANCE;
    }

    private static class SqlWithItemOperator
    extends SqlSpecialOperator {
        private static final SqlWithItemOperator INSTANCE = new SqlWithItemOperator();

        SqlWithItemOperator() {
            super("WITH_ITEM", SqlKind.WITH_ITEM, 0);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWithItem withItem = (SqlWithItem)call;
            withItem.name.unparse(writer, this.getLeftPrec(), this.getRightPrec());
            if (withItem.columnList != null) {
                withItem.columnList.unparse(writer, this.getLeftPrec(), this.getRightPrec());
            }
            writer.keyword("AS");
            withItem.query.unparse(writer, 200, 200);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            assert (operands.length == 3);
            return new SqlWithItem(pos, (SqlIdentifier)operands[0], (SqlNodeList)operands[1], operands[2]);
        }
    }
}

