/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class SqlWith
extends SqlCall {
    public SqlNodeList withList;
    public SqlNode body;

    public SqlWith(SqlParserPos pos, SqlNodeList withList, SqlNode body) {
        super(pos);
        this.withList = withList;
        this.body = body;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.WITH;
    }

    @Override
    public SqlOperator getOperator() {
        return SqlWithOperator.INSTANCE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.withList, this.body);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.withList = (SqlNodeList)operand;
                break;
            }
            case 1: {
                this.body = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateWith(this, scope);
    }

    private static class SqlWithOperator
    extends SqlSpecialOperator {
        private static final SqlWithOperator INSTANCE = new SqlWithOperator();

        private SqlWithOperator() {
            super("WITH", SqlKind.WITH, 2);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWith with = (SqlWith)call;
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.WITH, "WITH", "");
            SqlWriter.Frame frame1 = writer.startList("", "");
            for (SqlNode node : with.withList) {
                writer.sep(",");
                node.unparse(writer, 0, 0);
            }
            writer.endList(frame1);
            SqlWriter.Frame frame2 = writer.startList(SqlWriter.FrameTypeEnum.WITH_BODY);
            with.body.unparse(writer, INSTANCE.getLeftPrec(), INSTANCE.getRightPrec());
            writer.endList(frame2);
            writer.endList(frame);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlWith(pos, (SqlNodeList)operands[0], operands[1]);
        }

        @Override
        public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
            validator.validateWith((SqlWith)call, scope);
        }
    }
}

